/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.EntityHandler;
import de.qfm.erp.service.service.mapper.EntitySearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class EntitySearchRoute
extends AbstractSyncable<QEntity> {
    private static final Logger log = LogManager.getLogger(EntitySearchRoute.class);
    private final EntityHandler entityHandler;
    private final EntitySearchMapper entitySearchMapper;
    private final IndexService indexService;

    public EntitySearchRoute(@NonNull NodeConfig nodeConfig, @NonNull EntityHandler entityHandler, @NonNull EntitySearchMapper entitySearchMapper, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (entityHandler == null) {
            throw new NullPointerException("entityHandler is marked non-null but is null");
        }
        if (entitySearchMapper == null) {
            throw new NullPointerException("entitySearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.entityHandler = entityHandler;
        this.entitySearchMapper = entitySearchMapper;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.ENTITY;
    }

    @Nonnull
    public Iterable<QEntity> refresh(@NonNull Iterable<QEntity> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<QEntity> refresh(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        String entryId = Long.toString(entity.getId());
        try {
            IndexResult index = this.index(entity);
            log.debug("Refreshed Entity: {} in Index", (Object)entity);
            return Optional.of(entity);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)entity, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.entityHandler.dirty();
    }

    @Nonnull
    public Iterable<QEntity> streamDirty(int max) {
        return this.entityHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull QEntity item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<QEntity> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(QEntity::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<QEntity> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.entityHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries, amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        try {
            String documentId = EntitySearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)entity.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EStageIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)entity);
            return Optional.of(Long.toString(entity.getId()));
        }
        catch (IOException e) {
            log.error("Error Deleting Entry from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull QEntity entity) throws IOException {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        IndexDocument indexDocument = this.entitySearchMapper.mapToDocument(entity, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<QEntity> entities) throws IOException {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        Iterable indexDocuments = this.entitySearchMapper.mapToDocument(entities, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

