/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.ER2Helper;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceOutputBucket;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.service.route.ER2Route;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.stereotype.Service;

@Service
public class ER2RouteImpl
implements ER2Route {
    private final List<ER2InvoiceService> er2InvoiceServices;
    private Multimap<EInvoiceType, ER2InvoiceService> er2ServiceMap = ArrayListMultimap.create();

    @PostConstruct
    private void postConstruct() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.er2InvoiceServices.forEach(er2Service -> {
            Iterable invoiceTypes = er2Service.getInvoiceTypes();
            invoiceTypes.forEach(invoiceType -> builder.put(invoiceType, er2Service));
        });
        this.er2ServiceMap = builder.build();
    }

    @Nonnull
    public Iterable<ER2InvoiceOutputBucket> generate(@NonNull Iterable<Invoice> invoices) {
        if (invoices == null) {
            throw new NullPointerException("invoices is marked non-null but is null");
        }
        ImmutableMultimap.Builder rowsBuilder = ImmutableMultimap.builder();
        for (Invoice invoice : invoices) {
            EInvoiceType invoiceType = invoice.getInvoiceType();
            if (this.er2ServiceMap.containsKey((Object)invoiceType)) {
                Collection er2InvoiceServices = this.er2ServiceMap.get((Object)invoiceType);
                for (ER2InvoiceService er2InvoiceService : er2InvoiceServices) {
                    EER2OutputType outputType = er2InvoiceService.getOutputType();
                    Iterable er2Rows = er2InvoiceService.generate(invoice);
                    rowsBuilder.put((Object)outputType, (Object)er2Rows);
                }
                continue;
            }
            throw new NotImplementedException(String.format("Invoice Type: %s not implemented for ER2", invoiceType));
        }
        ImmutableMultimap build = rowsBuilder.build();
        ImmutableSet eer2OutputTypes = build.keySet();
        ImmutableList.Builder bucketBuilder = ImmutableList.builder();
        for (EER2OutputType eer2OutputType : eer2OutputTypes) {
            ImmutableCollection iterables = build.get((Object)eer2OutputType);
            Iterable collect = iterables.stream().flatMap(Streams::stream).collect(Collectors.toList());
            byte[] bytes = ER2Helper.asBytes((Iterable)collect);
            bucketBuilder.add((Object)ER2InvoiceOutputBucket.of((EER2OutputType)eer2OutputType, (byte[])bytes));
        }
        return bucketBuilder.build();
    }

    public ER2RouteImpl(List<ER2InvoiceService> er2InvoiceServices) {
        this.er2InvoiceServices = er2InvoiceServices;
    }
}

