/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import de.qfm.erp.common.request.generic.DictionaryItemUpdateRequest;
import de.qfm.erp.common.response.generic.DictionaryItemCommon;
import de.qfm.erp.common.response.generic.DictionaryItemPageCommon;
import de.qfm.erp.common.response.generic.DictionarySubItemListCommon;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.eventbus.AttendanceChangeMessage;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.generic.DictionaryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.service.handler.DictionaryItemHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.PayrollItemTypeHandler;
import de.qfm.erp.service.service.mapper.DictionaryItemMapper;
import de.qfm.erp.service.service.route.DictionaryItemRoute;
import de.qfm.erp.service.service.route.impl.DictionaryItemRouteImpl;
import de.qfm.erp.service.service.validator.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DictionaryItemRouteImpl
implements DictionaryItemRoute,
ApplicationListener<AttendanceChangeMessage> {
    private static final Logger log = LogManager.getLogger(DictionaryItemRouteImpl.class);
    private static final Map<EEntityClass, Integer> MAX_SIZE = ImmutableMap.of((Object)EEntityClass.AUTHORITY_TO_SIGN, (Object)25);
    private final EntityFactory entityFactory;
    private final DictionaryItemHandler handler;
    private final DictionaryItemMapper mapper;
    private final PayrollItemTypeHandler payrollItemTypeHandler;

    @Nonnull
    public DictionaryItemPageCommon page(int page, int size, @NonNull String filterText, boolean includeHidden) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.mapper.map(this.handler.page(page, size, filterText, includeHidden), (arg_0, arg_1) -> this.fn(arg_0, arg_1));
    }

    @Nonnull
    public DictionaryItemCommon byId(long id) {
        return this.mapper.map((DictionaryItem)this.handler.byIdFailing(Long.valueOf(id)), (arg_0, arg_1) -> this.fn(arg_0, arg_1));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public DictionaryItemPageCommon pageForEntity(@NonNull String entityClazzCandidate, int page, int size, @NonNull String filterText, boolean includeHidden) {
        if (entityClazzCandidate == null) {
            throw new NullPointerException("entityClazzCandidate is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Optional eEntityClassCandidate = EEntityClass.lookup((String)entityClazzCandidate);
        if (eEntityClassCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ENTITY_CLASS), (String)entityClazzCandidate, EEntityClass.class, EEntityClass::allowedKeys);
        }
        EEntityClass eEntityClass = (EEntityClass)eEntityClassCandidate.get();
        return this.mapper.map(this.handler.pageForEntity(eEntityClass, page, size, filterText, includeHidden), (arg_0, arg_1) -> this.fn(arg_0, arg_1));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public DictionaryItemPageCommon pageForEntity(@NonNull String entityClazzCandidate, long entityId, int page, int size, @NonNull String filterText, boolean includeHidden) {
        if (entityClazzCandidate == null) {
            throw new NullPointerException("entityClazzCandidate is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Optional eEntityClassCandidate = EEntityClass.lookup((String)entityClazzCandidate);
        if (eEntityClassCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ENTITY_CLASS), (String)entityClazzCandidate, EEntityClass.class, EEntityClass::allowedKeys);
        }
        EEntityClass eEntityClass = (EEntityClass)eEntityClassCandidate.get();
        return this.mapper.map(this.handler.pageForEntity(eEntityClass, entityId, page, size, filterText, includeHidden), (arg_0, arg_1) -> this.fn(arg_0, arg_1));
    }

    @Nonnull
    public DictionaryItemCommon create(@Nonnull DictionaryItemUpdateRequest updateRequest) {
        DictionaryItem dictionaryItem = this.entityFactory.dictionaryItem();
        EEntityClass entityClass = DictionaryItemRouteImpl.entityClazz((DictionaryItemUpdateRequest)updateRequest);
        this.validateLength(updateRequest, entityClass);
        DictionaryItem dictionaryItemMerged = this.mapper.merge(dictionaryItem, entityClass, updateRequest);
        DictionaryItem dictionaryItemUpdated = (DictionaryItem)this.handler.update((EntityBase)dictionaryItemMerged);
        return this.mapper.map(dictionaryItemUpdated, (arg_0, arg_1) -> this.fn(arg_0, arg_1));
    }

    @Nonnull
    public DictionaryItemCommon update(long id, @Nonnull DictionaryItemUpdateRequest updateRequest) {
        DictionaryItem dictionaryItem = (DictionaryItem)this.handler.byIdFailing(Long.valueOf(id));
        EEntityClass entityClass = DictionaryItemRouteImpl.entityClazz((DictionaryItemUpdateRequest)updateRequest);
        this.validateLength(updateRequest, entityClass);
        DictionaryItem dictionaryItemMerged = this.mapper.merge(dictionaryItem, entityClass, updateRequest);
        DictionaryItem dictionaryItemUpdated = (DictionaryItem)this.handler.update((EntityBase)dictionaryItemMerged);
        return this.mapper.map(dictionaryItemUpdated, (arg_0, arg_1) -> this.fn(arg_0, arg_1));
    }

    @Nonnull
    public DictionarySubItemListCommon listSubType(@NonNull String entityClazzCandidate) {
        if (entityClazzCandidate == null) {
            throw new NullPointerException("entityClazzCandidate is marked non-null but is null");
        }
        ImmutableList.Builder subtypesList = ImmutableList.builder();
        Optional entityClassOptional = EEntityClass.lookup((String)entityClazzCandidate);
        if (entityClassOptional.isPresent()) {
            EEntityClass entityClass = (EEntityClass)entityClassOptional.get();
            switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$history$type$EEntityClass[entityClass.ordinal()]) {
                case 1: {
                    this.payrollItemTypeHandler.page(Pageable.unpaged()).forEach(item -> subtypesList.add((Object)Pair.of((Object)item.getId(), (Object)item.getName())));
                    break;
                }
            }
        }
        ImmutableList subTypes = subtypesList.build();
        return this.mapper.map((List)subTypes);
    }

    @Nonnull
    private static EEntityClass entityClazz(@NonNull DictionaryItemUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        String entityClazzCandidate = updateRequest.getEntityClass();
        Optional lookup = EEntityClass.lookup((String)entityClazzCandidate);
        if (lookup.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ENTITY_CLASS), (String)entityClazzCandidate, EEntityClass.class, EEntityClass::allowedKeys);
        }
        return (EEntityClass)lookup.get();
    }

    public void onApplicationEvent(@NonNull AttendanceChangeMessage changeMessage) {
        String constructionSiteCleaned;
        Iterable dictionaryItemCandidate;
        if (changeMessage == null) {
            throw new NullPointerException("changeMessage is marked non-null but is null");
        }
        Attendance attendance = (Attendance)changeMessage.getEntity();
        String constructionSite = attendance.getConstructionSite();
        if (StringUtils.isNotBlank((CharSequence)constructionSite) && Iterables.isEmpty((Iterable)(dictionaryItemCandidate = this.handler.byNameIgnoreCaseNotFailing(EEntityClass.CONSTRUCTION_SITE, constructionSiteCleaned = StringUtils.trimToEmpty((String)constructionSite))))) {
            DictionaryItem dictionaryItem = this.entityFactory.dictionaryItem();
            dictionaryItem.setEntityClass(EEntityClass.CONSTRUCTION_SITE);
            dictionaryItem.setName(constructionSiteCleaned);
            dictionaryItem.setDescription("");
            this.handler.update((EntityBase)dictionaryItem);
        }
    }

    private void validateLength(@NonNull DictionaryItemUpdateRequest updateRequest, @NonNull EEntityClass entityClass) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        Integer maxLength = MAX_SIZE.getOrDefault(entityClass, 250);
        String name = StringUtils.trimToEmpty((String)updateRequest.getName());
        if (StringUtils.length((CharSequence)name) > maxLength) {
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.DICTIONARY__NAME), (Object)name, String.format("Dictionary Name can only have: %s chars, you entered: %s chars", maxLength, StringUtils.length((CharSequence)name)), Message.of((EMessageKey)EMessageKey.DICTIONARY_ITEM_NAME__TOO_LONG_FOR_ENTITY, (List)ImmutableList.of((Object)maxLength, (Object)StringUtils.length((CharSequence)name))));
        }
    }

    public String fn(EEntityClass entityClass, Long aLong) {
        if (null != aLong && Objects.equals(entityClass, EEntityClass.PAYROLL_ITEM_TYPE)) {
            return this.payrollItemTypeHandler.byIdNotFailing(aLong).map(PayrollItemType::getName).orElse("");
        }
        return "";
    }

    public DictionaryItemRouteImpl(EntityFactory entityFactory, DictionaryItemHandler handler, DictionaryItemMapper mapper, PayrollItemTypeHandler payrollItemTypeHandler) {
        this.entityFactory = entityFactory;
        this.handler = handler;
        this.mapper = mapper;
        this.payrollItemTypeHandler = payrollItemTypeHandler;
    }
}

