/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.response.user.UserAutoCompleteResponse;
import de.qfm.erp.service.helper.ASCIIFoldingHelper;
import de.qfm.erp.service.helper.DateRangeHelper;
import de.qfm.erp.service.helper.UserAutocompleteComparator;
import de.qfm.erp.service.helper.UserAutocompleteScorer;
import de.qfm.erp.service.model.exception.request.EnumNotFoundException;
import de.qfm.erp.service.model.internal.payroll.IAggregatedAttendanceUser;
import de.qfm.erp.service.model.internal.payroll.IAggregatedPayrollUser;
import de.qfm.erp.service.model.internal.user.AutoCompleteBucket;
import de.qfm.erp.service.model.internal.user.AutoCompleteUser;
import de.qfm.erp.service.model.internal.user.CachedAutoCompleteUser;
import de.qfm.erp.service.model.internal.user.CachedUser;
import de.qfm.erp.service.model.internal.user.EAutoCompleteMode;
import de.qfm.erp.service.model.internal.user.ScoredUser;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.AttendanceHandler;
import de.qfm.erp.service.service.handler.LaborUnionContractHandler;
import de.qfm.erp.service.service.handler.PayrollMonthHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.AutoCompleteMapper;
import de.qfm.erp.service.service.route.AutoCompleteRoute;
import de.qfm.erp.service.service.route.impl.AutoCompleteRouteImpl;
import de.qfm.erp.service.service.security.UserAutoCompleteService;
import de.qfm.erp.service.service.security.UserService;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AutoCompleteRouteImpl
implements AutoCompleteRoute {
    private static final Logger log = LogManager.getLogger(AutoCompleteRouteImpl.class);
    private static final Splitter SEARCH_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();
    private static final Joiner J = Joiner.on((char)' ').skipNulls();
    private final AutoCompleteMapper mapper;
    private final AttendanceHandler attendanceHandler;
    private final LaborUnionContractHandler laborUnionContractHandler;
    private final UserHandler userHandler;
    private final PayrollMonthHandler payrollMonthHandler;
    private final UserAutoCompleteService userAutoCompleteService;
    private final UserService userService;

    @Nonnull
    public UserAutoCompleteResponse standardAutoCompleteV1(long userId, @NonNull String autoCompleteModeCandidate, @NonNull String filterText, @Nullable LocalDate unsafeReferenceDate) {
        if (autoCompleteModeCandidate == null) {
            throw new NullPointerException("autoCompleteModeCandidate is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        LocalDate referenceDate = (LocalDate)MoreObjects.firstNonNull((Object)unsafeReferenceDate, (Object)DateTimeHelper.today());
        EAutoCompleteMode autoCompleteMode = EAutoCompleteMode.lookup((String)autoCompleteModeCandidate, (EAutoCompleteMode)EAutoCompleteMode.ALL);
        User user = (User)this.userHandler.byIdFailing(Long.valueOf(userId));
        ImmutableList.Builder cachedUsersBuilder = ImmutableList.builder();
        boolean filterOnlyValidRoles = true;
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$user$EAutoCompleteMode[autoCompleteMode.ordinal()]) {
            default: {
                cachedUsersBuilder.addAll(this.userService.all());
                break;
            }
            case 2: {
                boolean canAccessAll = this.userService.hasPrivilege(user, EPrivilege.PAYROLL_MONTH__ALL_USERS_ACCESSIBLE);
                if (canAccessAll) {
                    cachedUsersBuilder.addAll(this.userService.allActiveUsersAt(referenceDate));
                    break;
                }
                cachedUsersBuilder.addAll(this.userService.usersAssignedToAt(user, referenceDate));
                break;
            }
            case 3: {
                filterOnlyValidRoles = false;
                cachedUsersBuilder.addAll(this.userService.allActiveUsersAt(referenceDate));
                break;
            }
            case 4: 
            case 5: {
                ImmutableList allowedKeys = ImmutableList.of((Object)EAutoCompleteMode.ALL.name(), (Object)EAutoCompleteMode.PAYROLL_MONTH.name());
                String message = String.format("AutoComplete V1 does only support: %s", allowedKeys);
                throw new EnumNotFoundException(() -> "autocomplete_mode", (Object)autoCompleteModeCandidate, message, (List)allowedKeys);
            }
        }
        ImmutableList cachedUsers = cachedUsersBuilder.build();
        Iterable autoCompleteBuckets = AutoCompleteRouteImpl.applyFilter((Iterable)cachedUsers, (String)filterText, (boolean)filterOnlyValidRoles, (T x) -> false);
        return this.mapper.map(autoCompleteBuckets);
    }

    @Nonnull
    public UserAutoCompleteResponse standardAutoCompleteV2(long userId, @NonNull String autoCompleteModeCandidate, @NonNull String filterText, @Nullable LocalDate unsafeReferenceDate, @Nullable LocalDate unsafeReferenceDateRangeFrom, @Nullable LocalDate unsafeReferenceDateRangeTo, boolean optionTruncateDateToMonth) {
        if (autoCompleteModeCandidate == null) {
            throw new NullPointerException("autoCompleteModeCandidate is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        LocalDate referenceDate = (LocalDate)MoreObjects.firstNonNull((Object)unsafeReferenceDate, (Object)DateTimeHelper.today());
        Range dateRange = DateRangeHelper.dateRange((LocalDate)unsafeReferenceDateRangeFrom, (LocalDate)unsafeReferenceDateRangeTo);
        EAutoCompleteMode autoCompleteMode = EAutoCompleteMode.lookup((String)autoCompleteModeCandidate, (EAutoCompleteMode)EAutoCompleteMode.ALL);
        ImmutableList.Builder cachedUserBuilder = ImmutableList.builder();
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$user$EAutoCompleteMode[autoCompleteMode.ordinal()]) {
            case 3: 
            case 4: {
                cachedUserBuilder.addAll(this.userAutoCompleteService.allActiveUserInDateRange(Range.singleton((Comparable)referenceDate), optionTruncateDateToMonth));
                break;
            }
            case 5: {
                cachedUserBuilder.addAll(this.userAutoCompleteService.allActiveUserInDateRange(dateRange, optionTruncateDateToMonth));
                break;
            }
            case 2: {
                User user = (User)this.userHandler.byIdFailing(Long.valueOf(userId));
                boolean canAccessAll = this.userService.hasPrivilege(user, EPrivilege.PAYROLL_MONTH__ALL_USERS_ACCESSIBLE);
                if (canAccessAll) {
                    cachedUserBuilder.addAll(this.userAutoCompleteService.allActiveUserInDateRange(Range.singleton((Comparable)referenceDate), optionTruncateDateToMonth));
                    break;
                }
                cachedUserBuilder.addAll(this.userAutoCompleteService.singleton(user));
                break;
            }
            default: {
                ImmutableList allowedKeys = ImmutableList.of((Object)EAutoCompleteMode.ALL_ACTIVE_AT_DATE.name(), (Object)EAutoCompleteMode.ALL_ACTIVE_IN_DATE_RANGE.name());
                String message = String.format("AutoComplete V2 does only support: %s", allowedKeys);
                throw new EnumNotFoundException(() -> "autocomplete_mode", (Object)autoCompleteModeCandidate, message, (List)allowedKeys);
            }
        }
        ImmutableList cachedUsers = cachedUserBuilder.build();
        Iterable autoCompleteBuckets = AutoCompleteRouteImpl.applyFilter((Iterable)cachedUsers, (String)filterText, (T x) -> false);
        return this.mapper.mapAutoComplete(autoCompleteBuckets);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public UserAutoCompleteResponse payrollMonthAutoComplete(long payrollMonthId, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        PayrollMonth payrollMonth = (PayrollMonth)this.payrollMonthHandler.byIdFailing(Long.valueOf(payrollMonthId));
        LocalDate accountingMonth = payrollMonth.getAccountingMonth();
        Function disabledUserFunction = this.releasedPayrollFunctionForCachedUser(accountingMonth);
        Iterable allCachedUsers = this.userService.allActiveUsersAt(accountingMonth);
        Iterable autoCompleteBuckets = AutoCompleteRouteImpl.applyFilter((Iterable)allCachedUsers, (String)filterText, (boolean)false, (Function)disabledUserFunction);
        return this.mapper.map(autoCompleteBuckets);
    }

    @Nonnull
    public UserAutoCompleteResponse badWeatherAutoComplete(@NonNull LocalDate referenceDate, @NonNull String filterText) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        YearMonth accountingMonth = YearMonth.from(referenceDate);
        boolean currentMonth = accountingMonth.equals(YearMonth.now());
        Iterable badWeatherContracts = this.laborUnionContractHandler.badWeatherContracts();
        Iterable badWeatherContractIds = (Iterable)Streams.stream((Iterable)badWeatherContracts).map(LaborUnionContract::getId).collect(ImmutableSet.toImmutableSet());
        Iterable cachedUsers = this.userService.allActiveUsersAt(referenceDate);
        Iterable cachedUsersWithContract = (Iterable)Streams.stream((Iterable)cachedUsers).filter(item -> Iterables.contains((Iterable)badWeatherContractIds, (Object)item.getCurrentLaborUnionContractId())).collect(ImmutableList.toImmutableList());
        if (currentMonth && !Iterables.isEmpty((Iterable)cachedUsersWithContract)) {
            Iterable relevantUserIds = (Iterable)Streams.stream((Iterable)cachedUsersWithContract).map(CachedUser::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Function alreadyPresentBadWeatherFn = this.alreadyBadWeatherEntered(relevantUserIds, referenceDate);
            Function releasedFn = this.postEditOrReleasedFn(relevantUserIds, accountingMonth.atDay(1));
            Function<CachedUser, Boolean> disabledUserFunction = cachedUser -> {
                Boolean released = (Boolean)releasedFn.apply(cachedUser);
                Boolean alreadyBadWeatherOrPayrollMonthPostEdit = (Boolean)alreadyPresentBadWeatherFn.apply(cachedUser);
                return released != false || alreadyBadWeatherOrPayrollMonthPostEdit != false;
            };
            Iterable autoCompleteBuckets = AutoCompleteRouteImpl.applyFilter((Iterable)cachedUsersWithContract, (String)filterText, (boolean)false, disabledUserFunction);
            return this.mapper.map(autoCompleteBuckets);
        }
        return this.mapper.map(AutoCompleteRouteImpl.applyFilter((Iterable)cachedUsersWithContract, (String)"", (boolean)false, (T x) -> true));
    }

    @Nonnull
    private static Iterable<AutoCompleteBucket<CachedUser>> applyFilter(@NonNull Iterable<CachedUser> users, @NonNull String filterText, boolean filterOnlyWithRole, @NonNull Function<CachedUser, Boolean> disabledFunction) {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (disabledFunction == null) {
            throw new NullPointerException("disabledFunction is marked non-null but is null");
        }
        Predicate<CachedUser> filterByRole = filterOnlyWithRole ? input -> !Iterables.isEmpty((Iterable)input.getRoleIds()) : input -> true;
        Iterable terms = (Iterable)Streams.stream((Iterable)SEARCH_SPLITTER.split((CharSequence)filterText)).map(ASCIIFoldingHelper::foldString).collect(ImmutableList.toImmutableList());
        Predicate<CachedUser> filterByName = StringUtils.isNotBlank((CharSequence)filterText) ? input -> AutoCompleteRouteImpl.filter((CachedUser)input, (Iterable)terms) : input -> true;
        UserAutocompleteScorer scorer = UserAutocompleteScorer.of((Iterable)terms);
        UserAutocompleteComparator comparator = UserAutocompleteComparator.of();
        return ImmutableList.copyOf(Streams.stream(users).filter(filterByRole).filter(filterByName).map(arg_0 -> ((UserAutocompleteScorer)scorer).score(arg_0)).sorted((Comparator<ScoredUser>)comparator).map(ScoredUser::getUser).map(item -> {
            boolean disabledFlag = (Boolean)disabledFunction.apply((CachedUser)item);
            return AutoCompleteBucket.of((AutoCompleteUser)item, (boolean)disabledFlag);
        }).iterator());
    }

    @Nonnull
    private static Iterable<AutoCompleteBucket<CachedAutoCompleteUser>> applyFilter(@NonNull Iterable<CachedAutoCompleteUser> users, @NonNull String filterText, @NonNull Function<CachedAutoCompleteUser, Boolean> disabledFunction) {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (disabledFunction == null) {
            throw new NullPointerException("disabledFunction is marked non-null but is null");
        }
        Iterable terms = (Iterable)Streams.stream((Iterable)SEARCH_SPLITTER.split((CharSequence)filterText)).map(ASCIIFoldingHelper::foldString).collect(ImmutableList.toImmutableList());
        Predicate<CachedAutoCompleteUser> filterByName = StringUtils.isNotBlank((CharSequence)filterText) ? input -> AutoCompleteRouteImpl.filter((CachedAutoCompleteUser)input, (Iterable)terms) : input -> true;
        UserAutocompleteScorer scorer = UserAutocompleteScorer.of((Iterable)terms);
        UserAutocompleteComparator comparator = UserAutocompleteComparator.of();
        return ImmutableList.copyOf(Streams.stream(users).filter(filterByName).map(arg_0 -> ((UserAutocompleteScorer)scorer).score(arg_0)).sorted((Comparator<ScoredUser>)comparator).map(ScoredUser::getUser).map(item -> {
            boolean disabledFlag = (Boolean)disabledFunction.apply((CachedAutoCompleteUser)item);
            return AutoCompleteBucket.of((AutoCompleteUser)item, (boolean)disabledFlag);
        }).iterator());
    }

    private static boolean filter(@NonNull CachedAutoCompleteUser user, @NonNull Iterable<String> foldedTerms) {
        String foldedTerm;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (foldedTerms == null) {
            throw new NullPointerException("foldedTerms is marked non-null but is null");
        }
        String text = J.join((Object)user.getFirstName(), (Object)user.getLastName(), new Object[]{user.getPersonalNumber()});
        String textFolded = ASCIIFoldingHelper.foldString((String)text);
        boolean ok = true;
        Iterator<String> iterator = foldedTerms.iterator();
        while (iterator.hasNext() && (ok = StringUtils.containsIgnoreCase((CharSequence)textFolded, (CharSequence)(foldedTerm = iterator.next())))) {
        }
        return ok;
    }

    private static boolean filter(@NonNull CachedUser user, @NonNull Iterable<String> foldedTerms) {
        String foldedTerm;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (foldedTerms == null) {
            throw new NullPointerException("foldedTerms is marked non-null but is null");
        }
        String text = J.join((Object)user.getFirstName(), (Object)user.getLastName(), new Object[]{user.getPersonalNumber()});
        String textFolded = ASCIIFoldingHelper.foldString((String)text);
        boolean ok = true;
        Iterator<String> iterator = foldedTerms.iterator();
        while (iterator.hasNext() && (ok = StringUtils.containsIgnoreCase((CharSequence)textFolded, (CharSequence)(foldedTerm = iterator.next())))) {
        }
        return ok;
    }

    @Nonnull
    private Function<CachedUser, Boolean> releasedPayrollFunctionForCachedUser(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable releasePayrollsWithUser = this.payrollMonthHandler.releasedPayrollIdAndUserIdForMonth(referenceDate);
        Iterable usersIdsWithReleaseState = (Iterable)Streams.stream((Iterable)releasePayrollsWithUser).map(IAggregatedPayrollUser::getUserId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return cachedUser -> Iterables.contains((Iterable)usersIdsWithReleaseState, (Object)cachedUser.getId());
    }

    @Nonnull
    private Function<CachedUser, Boolean> postEditOrReleasedFn(@NonNull Iterable<Long> relevantUserIds, @NonNull LocalDate referenceDate) {
        if (relevantUserIds == null) {
            throw new NullPointerException("relevantUserIds is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable badWeatherBlockedAttendances = this.attendanceHandler.releasedPayrollMonthAttendances(referenceDate, relevantUserIds);
        Iterable usersIdsWithReleaseState = (Iterable)Streams.stream((Iterable)badWeatherBlockedAttendances).map(IAggregatedAttendanceUser::getUserId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return cachedUser -> Iterables.contains((Iterable)usersIdsWithReleaseState, (Object)cachedUser.getId());
    }

    @Nonnull
    private Function<CachedUser, Boolean> alreadyBadWeatherEntered(@NonNull Iterable<Long> relevantUserIds, @NonNull LocalDate referenceDate) {
        if (relevantUserIds == null) {
            throw new NullPointerException("relevantUserIds is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Iterable attendancesAtSameDayForUsers = this.attendanceHandler.alreadyOfTypeOrPayrollMonthEdited(referenceDate, relevantUserIds, (Iterable)ImmutableSet.of((Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK));
        Iterable alreadyKnownBadWeatherPresentUserIdsAtDay = (Iterable)Streams.stream((Iterable)attendancesAtSameDayForUsers).map(IAggregatedAttendanceUser::getUserId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return cachedUser -> Iterables.contains((Iterable)alreadyKnownBadWeatherPresentUserIdsAtDay, (Object)cachedUser.getId());
    }

    public AutoCompleteRouteImpl(AutoCompleteMapper mapper, AttendanceHandler attendanceHandler, LaborUnionContractHandler laborUnionContractHandler, UserHandler userHandler, PayrollMonthHandler payrollMonthHandler, UserAutoCompleteService userAutoCompleteService, UserService userService) {
        this.mapper = mapper;
        this.attendanceHandler = attendanceHandler;
        this.laborUnionContractHandler = laborUnionContractHandler;
        this.userHandler = userHandler;
        this.payrollMonthHandler = payrollMonthHandler;
        this.userAutoCompleteService = userAutoCompleteService;
        this.userService = userService;
    }
}

