/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route;

import de.qfm.erp.service.repository.QuotationRepository;
import de.qfm.erp.service.service.service.StageHelperService;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdministrationRoute {
    private static final Logger log = LogManager.getLogger(AdministrationRoute.class);
    private final QuotationRepository quotationRepository;
    private final StageHelperService stageHelperService;

    @Transactional
    public int refreshBudgets() {
        AtomicInteger atomicInt = new AtomicInteger(0);
        Stream all = this.quotationRepository.streamAll();
        all.forEach(stage -> {
            int i = atomicInt.incrementAndGet();
            log.info("Calculating Budget for: {} / {})", (Object)stage.getQNumber(), (Object)i);
            BigDecimal budget = this.stageHelperService.budget(stage);
            stage.setBudget(budget);
            this.quotationRepository.save(stage);
            log.info("Calculated Budget for: {} / {}", (Object)stage.getQNumber(), (Object)i);
        });
        return atomicInt.get();
    }

    @Autowired
    public AdministrationRoute(QuotationRepository quotationRepository, StageHelperService stageHelperService) {
        this.quotationRepository = quotationRepository;
        this.stageHelperService = stageHelperService;
    }
}

