/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EEntityIndexField;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EInvoiceIndexField;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.ESubProjectIndexField;
import de.qfm.erp.service.model.search.EUserIndexField;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.PreparedQuery;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DomainQueryHelper {
    private static final Logger log = LogManager.getLogger(DomainQueryHelper.class);
    private static final float EXACT_MULTIPLIER = 2.5f;
    private static final float PREFIX_MULTIPLIER = 0.9f;
    private static final float WILDCARD_MULTIPLIER = 0.5f;
    private final Analyzer indexAnalyzer;
    private static final Splitter QUERY_SPLITTER = Splitter.on((CharMatcher)CharMatcher.whitespace()).trimResults().omitEmptyStrings();
    private static final boolean INFIX_QUERY = false;
    private static final CharMatcher RETAIN_IN_QUERY = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.anyOf((CharSequence)"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff")).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"/_"));

    @Autowired
    public DomainQueryHelper(@Qualifier(value="indexAnalyzer") Analyzer indexAnalyzer) {
        this.indexAnalyzer = indexAnalyzer;
    }

    @Nonnull
    public static TermQuery customerQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.CUSTOMER);
    }

    @Nonnull
    public static TermQuery entityQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.ENTITY);
    }

    @Nonnull
    public static TermQuery invoiceQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.INVOICE);
    }

    @Nonnull
    public static TermQuery measurementQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.MEASUREMENT);
    }

    @Nonnull
    public static TermQuery stagesQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.STAGE);
    }

    @Nonnull
    public static TermQuery subProjectQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.SUB_PROJECT);
    }

    @Nonnull
    public static TermQuery usersQuery() {
        return InternalQueryHelper.documentTypeQuery((EIndexEntryType)EIndexEntryType.USER);
    }

    @Nonnull
    public PreparedQuery customers(@NonNull String query, @NonNull Iterable<ECustomerState> customerStates) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (customerStates == null) {
            throw new NullPointerException("customerStates is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.customerQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(ECustomerIndexField.CUSTOMER__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        ImmutableSet customerStateValues = (ImmutableSet)Streams.stream(customerStates).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.customerStatesFilter((Iterable)customerStateValues).ifPresent(item -> builder.add(item, BooleanClause.Occur.FILTER));
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    public PreparedQuery entities(@NonNull String query, @NonNull Iterable<EQEntityState> states) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (states == null) {
            throw new NullPointerException("states is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.entityQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(EEntityIndexField.ENTITY__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        ImmutableSet stateValues = (ImmutableSet)Streams.stream(states).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.qEntityStatesFilter((Iterable)stateValues).ifPresent(item -> builder.add(item, BooleanClause.Occur.FILTER));
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    public PreparedQuery measurements(@NonNull String query, @NonNull Iterable<EMeasurementState> measurementStates) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.measurementQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(EMeasurementIndexField.MEASUREMENT__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        ImmutableSet measurementStateValues = (ImmutableSet)Streams.stream(measurementStates).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.measurementStatesFilter((Iterable)measurementStateValues).ifPresent(item -> builder.add(item, BooleanClause.Occur.FILTER));
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    public PreparedQuery invoices(@NonNull String query, @NonNull Iterable<EInvoiceState> invoiceStates) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (invoiceStates == null) {
            throw new NullPointerException("invoiceStates is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.invoiceQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(EInvoiceIndexField.INVOICE__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        ImmutableSet invoiceStateValues = (ImmutableSet)Streams.stream(invoiceStates).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.invoiceStatesFilter((Iterable)invoiceStateValues).ifPresent(item -> builder.add(item, BooleanClause.Occur.FILTER));
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    public PreparedQuery stages(@NonNull String query, @NonNull Iterable<EQStageType> stageTypes, @NonNull Iterable<EQStageState> stageStates) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (stageTypes == null) {
            throw new NullPointerException("stageTypes is marked non-null but is null");
        }
        if (stageStates == null) {
            throw new NullPointerException("stageStates is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.stagesQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(EStageIndexField.STAGE__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        BooleanQuery.Builder stageTypeAndStateBuilder = new BooleanQuery.Builder();
        ImmutableSet stageTypeValues = (ImmutableSet)Streams.stream(stageTypes).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.stageTypesFilter((Iterable)stageTypeValues).ifPresent(item -> stageTypeAndStateBuilder.add(item, BooleanClause.Occur.FILTER));
        ImmutableSet stageStateValues = (ImmutableSet)Streams.stream(stageStates).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.stageStatesFilter((Iterable)stageStateValues).ifPresent(item -> stageTypeAndStateBuilder.add(item, BooleanClause.Occur.FILTER));
        BooleanQuery stageTypeAndState = stageTypeAndStateBuilder.build();
        builder.add((Query)stageTypeAndState, BooleanClause.Occur.FILTER);
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    public PreparedQuery subProjects(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.subProjectQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(ESubProjectIndexField.SUB_PROJECT__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    public PreparedQuery users(@NonNull String query, @NonNull Iterable<EntityState> entityStates) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (entityStates == null) {
            throw new NullPointerException("entityStates is marked non-null but is null");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        TermQuery documentQuery = DomainQueryHelper.usersQuery();
        builder.add((Query)documentQuery, BooleanClause.Occur.FILTER);
        Iterable standardTerms = DomainQueryHelper.standardTerms((String)query);
        Query fullTextQuery = this.fullTextQuery(EUserIndexField.USER__FULLTEXT_QUERY_FIELDS, standardTerms);
        builder.add(fullTextQuery, BooleanClause.Occur.FILTER);
        ImmutableSet entityStateValues = (ImmutableSet)Streams.stream(entityStates).map(Enum::name).collect(ImmutableSet.toImmutableSet());
        this.userStatesFilter((Iterable)entityStateValues).ifPresent(item -> builder.add(item, BooleanClause.Occur.FILTER));
        BooleanQuery luceneQuery = builder.build();
        return PreparedQuery.of((Iterable)standardTerms, (Query)luceneQuery);
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<String> standardTerms(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        String retainedQuery = RETAIN_IN_QUERY.negate().replaceFrom((CharSequence)query, (CharSequence)" ");
        List terms = QUERY_SPLITTER.splitToList((CharSequence)StringUtils.lowerCase((String)retainedQuery));
        return ImmutableSet.copyOf((Iterable)terms);
    }

    @Nonnull
    private Query fullTextQuery(@NonNull Iterable<? extends IndexField> fieldsToQuery, @NonNull Iterable<String> standardTerms) {
        if (fieldsToQuery == null) {
            throw new NullPointerException("fieldsToQuery is marked non-null but is null");
        }
        if (standardTerms == null) {
            throw new NullPointerException("standardTerms is marked non-null but is null");
        }
        if (!Iterables.isEmpty(standardTerms)) {
            ImmutableSet uniqueIndexFieldsToQuery = ImmutableSet.copyOf(fieldsToQuery);
            int termsCount = Iterables.size(standardTerms);
            BooleanQuery.Builder allTermsBuilder = new BooleanQuery.Builder();
            allTermsBuilder.setMinimumNumberShouldMatch(termsCount);
            for (String standardTerm : standardTerms) {
                BooleanQuery.Builder perTermBuilder = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1);
                for (IndexField currentIndexField : uniqueIndexFieldsToQuery) {
                    String valueToQuery = this.normalize(currentIndexField, standardTerm);
                    BooleanQuery.Builder disjunctionBuilder = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1);
                    disjunctionBuilder.add((Query)new BoostQuery((Query)InternalQueryHelper.termQuery((IndexField)currentIndexField, (String)valueToQuery), 2.5f), BooleanClause.Occur.SHOULD);
                    disjunctionBuilder.add((Query)new BoostQuery((Query)InternalQueryHelper.prefixQuery((IndexField)currentIndexField, (String)valueToQuery), 0.9f), BooleanClause.Occur.SHOULD);
                    BooleanQuery disjunction = disjunctionBuilder.build();
                    BoostQuery boostQuery = new BoostQuery((Query)disjunction, 1.0f);
                    perTermBuilder.add(new BooleanClause((Query)boostQuery, BooleanClause.Occur.SHOULD));
                }
                BooleanQuery perTermQuery = perTermBuilder.build();
                allTermsBuilder.add((Query)perTermQuery, BooleanClause.Occur.SHOULD);
            }
            return allTermsBuilder.build();
        }
        return new MatchAllDocsQuery();
    }

    @Nonnull
    private Optional<Query> measurementStatesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)EMeasurementIndexField.MEASUREMENT__MEASUREMENT_STATE, values);
    }

    @Nonnull
    private Optional<Query> customerStatesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)ECustomerIndexField.CUSTOMER__CUSTOMER_STATE, values);
    }

    @Nonnull
    private Optional<Query> qEntityStatesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)EEntityIndexField.ENTITY__QENTITY_STATE, values);
    }

    @Nonnull
    private Optional<Query> invoiceStatesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)EInvoiceIndexField.INVOICE__INVOICE_STATE, values);
    }

    @Nonnull
    private Optional<Query> stageTypesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)EStageIndexField.STAGE__STAGE_TYPE, values);
    }

    @Nonnull
    private Optional<Query> stageStatesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)EStageIndexField.STAGE__STAGE_STATE, values);
    }

    @Nonnull
    private Optional<Query> userStatesFilter(@NonNull Iterable<String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.multiStringValuesOnFieldFilter((IndexField)EUserIndexField.USER__ENTITY_STATE, values);
    }

    @Nonnull
    private Optional<Query> multiStringValuesOnFieldFilter(@NonNull IndexField field, @NonNull Iterable<String> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return InternalQueryHelper.termsQuery((IndexField)field, values);
    }

    @Nonnull
    protected String normalize(@NonNull IndexField field, @NonNull String candidate) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return this.indexAnalyzer.normalize(field.fieldName(), candidate).utf8ToString();
    }
}

