/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.validation.ValidationResultCommon;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.service.service.MessageService;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ValidationMapper {
    private static final Logger log = LogManager.getLogger(ValidationMapper.class);
    private final MessageService messageService;

    @NonNull
    public ValidationResultCommon map(@NonNull ValidationResult validationResult) {
        if (validationResult == null) {
            throw new NullPointerException("validationResult is marked non-null but is null");
        }
        Iterable messages = validationResult.getMessages();
        ImmutableList messagesTxt = (ImmutableList)Streams.stream((Iterable)messages).map(arg_0 -> ((MessageService)this.messageService).get(arg_0)).collect(ImmutableList.toImmutableList());
        return ValidationResultCommon.of((boolean)validationResult.isSuccess(), (Iterable)messagesTxt);
    }

    public ValidationMapper(MessageService messageService) {
        this.messageService = messageService;
    }
}

