/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.StageIndexEntry;
import de.qfm.erp.service.service.mapper.search.StageIndexEntrySerializer;
import de.qfm.erp.service.service.service.ConfigService;
import java.time.LocalDateTime;
import java.util.BitSet;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageSearchMapper {
    private static final Logger log = LogManager.getLogger(StageSearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private static final Splitter NAME_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"-,")).trimResults();
    private final StageIndexEntrySerializer stageIndexEntrySerializer;
    private final Analyzer indexAnalyzer;
    private final ConfigService configService;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull Quotation stage, @NonNull EIndexEntryType indexEntryType) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(stage, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<Quotation> stages, @NonNull EIndexEntryType indexEntryType) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(stages).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public StageIndexEntry mapToIndexEntry(@NonNull Quotation stage, @NonNull EIndexEntryType indexEntryType) {
        Customer customer;
        SubProject subProject;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        StageIndexEntry indexEntry = new StageIndexEntry();
        indexEntry.setId(stage.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(stage.getCreatedOn());
        indexEntry.setCreatedBy(stage.getCreatedBy());
        indexEntry.setUpdatedOn(stage.getUpdatedOn());
        indexEntry.setUpdatedBy(stage.getUpdatedBy());
        indexEntry.setPriority(this.priority(stage));
        indexEntry.setEntityState(stage.getEntityState());
        EQStageState stageState = (EQStageState)MoreObjects.firstNonNull((Object)stage.getStageState(), (Object)EQStageState.UNKNOWN);
        indexEntry.setStageState(stageState);
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)stage.getStageType(), (Object)EQStageType.UNKNOWN);
        indexEntry.setStageType(stageType);
        indexEntry.setStageNumber(stage.getQNumber());
        indexEntry.setStageAlias(stage.getAlias());
        QEntity qEntity = stage.getQEntity();
        if (null != qEntity) {
            indexEntry.setEntityId(qEntity.getId());
            indexEntry.setEntityNumber(qEntity.getQNumber());
            indexEntry.setEntityAlias(qEntity.getAlias());
        }
        indexEntry.setQuotationNumber(stage.getQuotationNumber());
        indexEntry.setVersion(stage.getVersion());
        indexEntry.setOrderNumber(stage.getOrderNumber());
        indexEntry.setOrderDescriptionInternal(stage.getOrderDescriptionInternal());
        indexEntry.setOrderDescriptionCustomer(stage.getOrderDescriptionCustomer());
        indexEntry.setProcurementNumber(stage.getProcurementNumber());
        Project project = stage.getProject();
        if (null != project) {
            indexEntry.setProjectId(project.getId());
            indexEntry.setProjectName(project.getName());
            indexEntry.setProjectReferenceId(project.getReferenceId());
        }
        if (null != (subProject = stage.getSubProject())) {
            indexEntry.setSubProjectId(subProject.getId());
            indexEntry.setSubProjectName(subProject.getName());
        }
        if (null != (customer = stage.getCustomer())) {
            indexEntry.setCustomerId(customer.getId());
            indexEntry.setCustomerName(customer.getName());
        }
        return indexEntry;
    }

    @Nonnull
    private Long priority(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        QEntity entity = stage.getQEntity();
        Quotation primaryStage = null != entity ? entity.getPrimaryStage() : null;
        boolean isPrimary = primaryStage == stage;
        BitSet bitSet = new BitSet();
        bitSet.set(0, isPrimary);
        bitSet.set(1, EQStageType.COMMISSION == stageType);
        bitSet.set(2, EQStageType.COMMISSION__COST_UNIT == stageType);
        bitSet.set(3, EQStageType.COMMISSION__COST_UNIT__CE == stageType);
        bitSet.set(4, EQStageType.COMMISSION__ADDENDUM == stageType);
        bitSet.set(5, EQStageType.COST_UNIT__ADDENDUM == stageType);
        bitSet.set(6, EQStageType.QUOTATION == stageType);
        bitSet.set(7, EQStageType.CALCULATION == stageType);
        bitSet.set(8, EQStageType.INQUIRY == stageType);
        return StageSearchMapper.convert((BitSet)bitSet);
    }

    public static long convert(@NonNull BitSet bits) {
        if (bits == null) {
            throw new NullPointerException("bits is marked non-null but is null");
        }
        long value = 0L;
        for (int i = 0; i < bits.length(); ++i) {
            value += bits.get(i) ? 1L << i : 0L;
        }
        return value;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull StageIndexEntry stageIndexEntry) {
        String source;
        Document document = new Document();
        String documentId = StageSearchMapper.documentId((StageIndexEntry)stageIndexEntry);
        String type = stageIndexEntry.getIndexEntryType().name();
        try {
            source = this.stageIndexEntrySerializer.serialize(stageIndexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)EStageIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)EStageIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EStageIndexField.STAGE__CREATED_ON, (LocalDateTime)stageIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EStageIndexField.STAGE__UPDATED_ON, (LocalDateTime)stageIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__CREATED_BY, (String)stageIndexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__UPDATED_BY, (String)stageIndexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__ENTITY_STATE, (String)stageIndexEntry.getEntityState().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__STAGE_TYPE, (String)stageIndexEntry.getStageType().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__STAGE_STATE, (String)stageIndexEntry.getStageState().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__STAGE_NUMBER, (String)StringUtils.removeStart((String)stageIndexEntry.getStageNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__STAGE_NUMBER, (String)stageIndexEntry.getStageNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__ENTITY_NUMBER, (String)StringUtils.removeStart((String)stageIndexEntry.getEntityNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__ENTITY_NUMBER, (String)stageIndexEntry.getEntityNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__STAGE_ALIAS, (String)stageIndexEntry.getStageAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__ENTITY_ALIAS, (String)stageIndexEntry.getEntityAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__QUOTATION_NUMBER, (String)StringUtils.remove((String)stageIndexEntry.getQuotationNumber(), (String)"/")).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EStageIndexField.STAGE__QUOTATION_NUMBER, (String)stageIndexEntry.getQuotationNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__ORDER_NUMBER, (String)stageIndexEntry.getOrderNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__ORDER_DESCRIPTION_CUSTOMER, (String)stageIndexEntry.getOrderDescriptionCustomer()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__ORDER_DESCRIPTION_INTERNAL, (String)stageIndexEntry.getOrderDescriptionInternal()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__PROCUREMENT_NUMBER, (String)stageIndexEntry.getProcurementNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)EStageIndexField.STAGE__PROJECT__ID, (Long)stageIndexEntry.getProjectId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__PROJECT__NAME, (String)stageIndexEntry.getProjectName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__PROJECT__REFERENCE_ID, (String)stageIndexEntry.getProjectReferenceId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)EStageIndexField.STAGE__SUBPROJECT__ID, (Long)stageIndexEntry.getSubProjectId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__SUBPROJECT__NAME, (String)stageIndexEntry.getSubProjectName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)EStageIndexField.STAGE__CUSTOMER__ID, (Long)stageIndexEntry.getCustomerId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EStageIndexField.STAGE__CUSTOMER__NAME, (String)stageIndexEntry.getCustomerName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        String allFromDocument = StageSearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)EStageIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EStageIndexField.SORT_STAGE__CREATED_ON, (LocalDateTime)stageIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EStageIndexField.SORT_STAGE__UPDATED_ON, (LocalDateTime)stageIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EStageIndexField.SORT_STAGE__PRIORITY, (Long)stageIndexEntry.getPriority()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull StageIndexEntry indexEntry) {
        if (indexEntry == null) {
            throw new NullPointerException("indexEntry is marked non-null but is null");
        }
        return StageSearchMapper.documentId((EIndexEntryType)indexEntry.getIndexEntryType(), (Long)indexEntry.getId());
    }

    @Nonnull
    public static String documentId(@NonNull EIndexEntryType indexEntryType, @NonNull Long id) {
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    @VisibleForTesting
    Iterable<String> handleName(@NonNull EStageIndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String normalizedValue = LuceneHelper.normalize((Analyzer)this.indexAnalyzer, (IndexField)field, (String)value);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)normalizedValue);
        Streams.stream((Iterable)NAME_SPLITTER.split((CharSequence)normalizedValue)).filter(StringUtils::isNotBlank).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        EStageIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public StageSearchMapper(StageIndexEntrySerializer stageIndexEntrySerializer, Analyzer indexAnalyzer, ConfigService configService) {
        this.stageIndexEntrySerializer = stageIndexEntrySerializer;
        this.indexAnalyzer = indexAnalyzer;
        this.configService = configService;
    }
}

