/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.customer.CustomerCommon;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.project.SubProjectCommon;
import de.qfm.erp.common.response.quotation.GaebImportResultCommon;
import de.qfm.erp.common.response.quotation.GaebImportResultListCommon;
import de.qfm.erp.common.response.quotation.QStageAutoCompleteItemCommon;
import de.qfm.erp.common.response.quotation.StageAutoCompleteResponse;
import de.qfm.erp.common.response.quotation.StageBudgetCommon;
import de.qfm.erp.common.response.quotation.StageCommon;
import de.qfm.erp.common.response.quotation.StageListCommon;
import de.qfm.erp.common.response.quotation.StagePageCommon;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.StageMergeResult;
import de.qfm.erp.service.model.internal.gaeb.GaebImportResult;
import de.qfm.erp.service.model.internal.measurement.MeasurementAccountData;
import de.qfm.erp.service.model.internal.quotation.EStagePositionSortOption;
import de.qfm.erp.service.model.internal.quotation.QStagePositionsUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.internal.quotation.StageBudget;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.ECommissionType;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.CustomerMapper;
import de.qfm.erp.service.service.mapper.ProjectMapper;
import de.qfm.erp.service.service.mapper.StageHeadMapper;
import de.qfm.erp.service.service.mapper.SubProjectMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class StageMapper {
    private static final Logger log = LogManager.getLogger(StageMapper.class);
    private final CustomerMapper customerMapper;
    private final ProjectMapper projectMapper;
    private final StageHeadMapper headMapper;
    private final SubProjectMapper subProjectMapper;

    @Nonnull
    public StageCommon mapToCommon(@NonNull QuotationBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        return this.headMapper.mapToCommon(bucket, false);
    }

    @Nonnull
    public StageCommon mapToCommon(@NonNull QuotationBucket bucket, boolean includeAllPos) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        return this.headMapper.mapToCommon(bucket, includeAllPos);
    }

    @Nonnull
    public Quotation mergeStage(@NonNull StageUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        return this.headMapper.mergeQStage(updateBucket);
    }

    @Nonnull
    public MergedBucket<QuotationPosition> mergePositions(@NonNull QStagePositionsUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        return this.headMapper.mergePositions(updateBucket);
    }

    @Nonnull
    public StageMergeResult mergeInto(@NonNull Quotation stageFrom, @NonNull Quotation stageTo, @NonNull EQStageType stageTypeNew, boolean stageCopyPositions, boolean resetAddendumNumber) {
        if (stageFrom == null) {
            throw new NullPointerException("stageFrom is marked non-null but is null");
        }
        if (stageTo == null) {
            throw new NullPointerException("stageTo is marked non-null but is null");
        }
        if (stageTypeNew == null) {
            throw new NullPointerException("stageTypeNew is marked non-null but is null");
        }
        return this.headMapper.mergeInto(stageFrom, stageTo, stageTypeNew, stageCopyPositions, resetAddendumNumber);
    }

    @Nonnull
    public GaebImportResultListCommon mapGaeb(@NonNull Iterable<GaebImportResult> gaebExtractResults) {
        if (gaebExtractResults == null) {
            throw new NullPointerException("gaebExtractResults is marked non-null but is null");
        }
        int size = Iterables.size(gaebExtractResults);
        ImmutableList commons = (ImmutableList)Streams.stream(gaebExtractResults).map(arg_0 -> this.mapGaeb(arg_0)).collect(ImmutableList.toImmutableList());
        return new GaebImportResultListCommon(size, (List)commons);
    }

    @Nonnull
    public GaebImportResultCommon mapGaeb(@NonNull GaebImportResult gaebExtractResult) {
        if (gaebExtractResult == null) {
            throw new NullPointerException("gaebExtractResult is marked non-null but is null");
        }
        Quotation quotation = gaebExtractResult.getQuotation();
        Iterable quotationPositions = gaebExtractResult.getQuotationPositions();
        ImmutableSet positionIDs = (ImmutableSet)IterableHelper.stream((Iterable)quotationPositions).map(QuotationPosition::getId).collect(ImmutableSet.toImmutableSet());
        GaebImportResultCommon common = new GaebImportResultCommon();
        common.setMultipartFileName(gaebExtractResult.getFileName());
        common.setErrors((List)ImmutableList.copyOf((Iterable)gaebExtractResult.getErrors()));
        common.setStageId(quotation.getId());
        common.setPositionIds((Set)positionIDs);
        return common;
    }

    @Nonnull
    public StageAutoCompleteResponse mapToAutoComplete(@NonNull Page<Quotation> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        List autoCompleteItems = (List)entities.stream().map(arg_0 -> this.mapToAutoComplete(arg_0)).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getText(), (String)r.getText())).collect(ImmutableList.toImmutableList());
        return new StageAutoCompleteResponse(entities.getSize(), autoCompleteItems);
    }

    @Nonnull
    public QStageAutoCompleteItemCommon mapToAutoComplete(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QStageAutoCompleteItemCommon common = new QStageAutoCompleteItemCommon();
        Long stageId = stage.getId();
        common.setStageId(stageId);
        String alias = stage.getAlias();
        common.setAlias(alias);
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)stage.getStageType(), (Object)EQStageType.UNKNOWN);
        common.setStageType(stageType.name());
        String qNumber = stage.getQNumber();
        common.setQentityNumber(qNumber);
        Long addendumNumber = stage.getAddendumNumber();
        common.setAddendumNumber(addendumNumber);
        Integer version = stage.getVersion();
        common.setVersion(version);
        EStagePositionSortOption stagePositionSortOption = (EStagePositionSortOption)MoreObjects.firstNonNull((Object)stage.getStagePositionSortOption(), (Object)EStagePositionSortOption.NONE);
        common.setStagePositionSortOption(stagePositionSortOption.name());
        String text = StageHelper.stageText((Quotation)stage, (boolean)true);
        common.setText(text);
        return common;
    }

    @Nonnull
    public StagePageCommon mapToPage(@NonNull Page<Quotation> stages, boolean includeRefs) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        return (StagePageCommon)BaseMapper.map(stages, item -> this.map(item, includeRefs), (pageNumber, pageSize, totalElements, totalPages, items) -> new StagePageCommon(pageNumber, pageSize, totalPages, totalElements, items), (l, r) -> StringUtils.compareIgnoreCase((String)l.getQentityNumber(), (String)r.getQentityNumber()));
    }

    @Nonnull
    public StageListCommon mapToList(@NonNull Iterable<Quotation> stages, boolean includeRefs) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        ImmutableList collect = (ImmutableList)IterableHelper.stream(stages).map(item -> this.map(item, includeRefs)).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getQentityNumber(), (String)r.getQentityNumber())).collect(ImmutableList.toImmutableList());
        return new StageListCommon(collect.size(), (List)collect);
    }

    @Nonnull
    public StageCommon map(@NonNull Quotation stage, boolean includeRefs) {
        QEntity entity;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        StageCommon common = new StageCommon();
        BaseMapper.map((EntityBase)stage, (EntityBaseCommon)common);
        common.setId(stage.getId());
        common.setAlias(stage.getAlias());
        common.setQentityNumber(stage.getQNumber());
        Project project = stage.getProject();
        if (project != null) {
            ProjectCommon projectCommon = this.projectMapper.map(project);
            common.setProject(projectCommon);
        }
        if ((entity = stage.getQEntity()) != null) {
            common.setQentityId(entity.getId());
            common.setQentityAlias(entity.getAlias());
            common.setQentityQEntityNumber(entity.getQNumber());
        }
        common.setVersion(stage.getVersion());
        common.setStageType(stage.getStageType().name());
        common.setStageState(stage.getStageState().name());
        common.setOrderDescriptionCustomer(stage.getOrderDescriptionCustomer());
        common.setOrderDescriptionInternal(stage.getOrderDescriptionInternal());
        common.setOrderNumber(stage.getOrderNumber());
        SubProject subProject = stage.getSubProject();
        if (null != subProject) {
            SubProjectCommon subProjectCommon = this.subProjectMapper.map(subProject);
            common.setSubProject(subProjectCommon);
        }
        common.setBudget(stage.getBudget());
        common.setProjectExecutionStartDate(stage.getProjectExecutionStartDate());
        common.setProjectExecutionEndDate(stage.getProjectExecutionEndDate());
        Customer customer = stage.getCustomer();
        if (null != customer) {
            CustomerCommon customerCommon = this.customerMapper.map(customer, false, false);
            common.setCustomer(customerCommon);
        }
        common.setNotifyUsersText(stage.getStageNotifyUsersText());
        common.setSignatureUsersText(stage.getStageSignatureUsersText());
        common.setResponsibleUsersText(stage.getStageResponsibleUsersText());
        common.setProcurementNumber(stage.getProcurementNumber());
        ECommissionType commissionType = (ECommissionType)MoreObjects.firstNonNull((Object)stage.getCommissionType(), (Object)ECommissionType.UNKNOWN);
        common.setCommissionType(commissionType.name());
        common.setPlannedSubmissionDate(stage.getPlannedSubmissionDate());
        common.setSubmissionDateTime(stage.getSubmissionDateTime());
        common.setBindingPeriodDate(stage.getBindingPeriodDate());
        common.setCommissionDate(stage.getCommissionDate());
        common.setGracePeriodDate(stage.getGracePeriodDate());
        common.setPriceWithDiscountSum(stage.getPriceWithDiscountSum());
        common.setPriceWithoutDiscountSum(stage.getPriceWithoutDiscountSum());
        common.setOrderValue(stage.getOrderValue());
        common.setOrderValueWithDiscount(stage.getOrderValueWithDiscount());
        common.setOrderValueEstimate(stage.getOrderValueEstimate());
        common.setFlagMeasurementWithoutCommissionNumberAllowed(stage.getFlagMeasurementWithoutCommissionNumberAllowed());
        if (includeRefs) {
            Quotation parent;
            Quotation reference = stage.getReference();
            if (null != reference) {
                common.setReferenceId(reference.getId());
            }
            if ((parent = stage.getParent()) != null) {
                common.setParentId(parent.getId());
            }
        }
        return common;
    }

    @Nonnull
    public StageBudgetCommon map(@NonNull Quotation stage, @NonNull Iterable<StageBudget> stageBudgets, @NonNull Iterable<MeasurementAccountData> measurementAccountData) {
        BigDecimal allowedOverDraftAbsolute;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (stageBudgets == null) {
            throw new NullPointerException("stageBudgets is marked non-null but is null");
        }
        if (measurementAccountData == null) {
            throw new NullPointerException("measurementAccountData is marked non-null but is null");
        }
        Long stageId = stage.getId();
        BigDecimal budgetAllowedOverdraftPercent = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getBudgetAllowedOverdraftPercent(), (Object)BigDecimal.ZERO);
        BigDecimal budgetAllowedOverdraftValue = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getBudgetAllowedOverdraftValue(), (Object)BigDecimal.ZERO);
        if (budgetAllowedOverdraftValue.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal orderValue = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getOrderValue(), (Object)BigDecimal.ZERO);
            allowedOverDraftAbsolute = budgetAllowedOverdraftPercent.divide(BigDecimal.valueOf(100L)).multiply(orderValue).setScale(2, RoundingMode.HALF_UP);
        } else {
            allowedOverDraftAbsolute = stage.getBudgetAllowedOverdraftValue();
        }
        BigDecimal budget = BigDecimal.ZERO;
        BigDecimal accountedEfforts = BigDecimal.ZERO;
        BigDecimal notAccountedEfforts = BigDecimal.ZERO;
        BigDecimal remainingBudget = BigDecimal.ZERO;
        BigDecimal overCheck = BigDecimal.valueOf(-1L);
        BigDecimal overDraft = BigDecimal.valueOf(-1L);
        for (StageBudget stageBudget : stageBudgets) {
            BigDecimal budgetLocal = (BigDecimal)MoreObjects.firstNonNull((Object)stageBudget.getOrderValue(), (Object)BigDecimal.ZERO);
            budget = budget.add(budgetLocal);
        }
        for (MeasurementAccountData measurementAccountDatum : measurementAccountData) {
            EMeasurementState measurementState = measurementAccountDatum.getMeasurementState();
            BigDecimal valueOverall = measurementAccountDatum.getValueOverall();
            if (EMeasurementState.ACCOUNTED_STATES.contains(measurementState)) {
                accountedEfforts = accountedEfforts.add(valueOverall);
                continue;
            }
            if (!EMeasurementState.NOT_ACCOUNTED_STATES.contains(measurementState)) continue;
            notAccountedEfforts = notAccountedEfforts.add(valueOverall);
        }
        BigDecimal allEfforts = notAccountedEfforts.add(accountedEfforts);
        remainingBudget = budget.subtract(allEfforts).max(BigDecimal.ZERO);
        overDraft = budget.subtract(allEfforts).negate();
        if (overDraft.compareTo(BigDecimal.ZERO) > 0) {
            if (overDraft.compareTo(allowedOverDraftAbsolute) >= 0 && overDraft.compareTo(allowedOverDraftAbsolute) >= 0) {
                overCheck = overDraft.subtract(allowedOverDraftAbsolute);
                overDraft = allowedOverDraftAbsolute;
            }
        } else {
            overCheck = BigDecimal.ZERO;
            overDraft = BigDecimal.ZERO;
        }
        StageBudgetCommon common = new StageBudgetCommon();
        common.setStageId(stageId.longValue());
        common.setBudget(budget);
        common.setAccountedEfforts(accountedEfforts);
        common.setNotAccountedEfforts(notAccountedEfforts);
        common.setRemainingBudget(remainingBudget);
        common.setOverCheck(overCheck);
        common.setOverDraft(overDraft);
        return common;
    }

    public StageMapper(CustomerMapper customerMapper, ProjectMapper projectMapper, StageHeadMapper headMapper, SubProjectMapper subProjectMapper) {
        this.customerMapper = customerMapper;
        this.projectMapper = projectMapper;
        this.headMapper = headMapper;
        this.subProjectMapper = subProjectMapper;
    }
}

