/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.quotation.StageInvoiceSupplementUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.quotation.StageInvoiceSupplementCommon;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.quotation.StageInvoiceSupplementBucket;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.StageInvoiceSupplement;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class StageInvoiceSupplementMapper {
    private static final Logger log = LogManager.getLogger(StageInvoiceSupplementMapper.class);
    private final AuthenticationHelper authenticationHelper;
    private final EntityFactory entityFactory;
    public static final BiConsumer<StageInvoiceSupplement, StageInvoiceSupplementBucket> NOOP = (entity, updateItem) -> {};

    @Nonnull
    public MergedBucket<StageInvoiceSupplement> merge(@NonNull StageUpdateBucket stageUpdateBucket) {
        if (stageUpdateBucket == null) {
            throw new NullPointerException("stageUpdateBucket is marked non-null but is null");
        }
        Quotation quotation = (Quotation)stageUpdateBucket.getEntity();
        Iterable supplementBuckets = stageUpdateBucket.getInvoiceSupplementBuckets();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)quotation, Quotation::getStageInvoiceSupplements, arg_0 -> ((Quotation)quotation).setStageInvoiceSupplements(arg_0), (Iterable)supplementBuckets, StageInvoiceSupplementBucket::getId, StageInvoiceSupplement::getId, () -> ((EntityFactory)this.entityFactory).stageInvoiceSupplement(), (arg_0, arg_1) -> this.mergeStateNotifyUser(arg_0, arg_1), StageInvoiceSupplement::setQuotation, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP);
        MergedBucket.printMergeBucket((Object)quotation, StageInvoiceSupplement.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public StageInvoiceSupplement mergeStateNotifyUser(@NonNull StageInvoiceSupplement stageInvoiceSupplement, @NonNull StageInvoiceSupplementBucket updateBucket) {
        if (stageInvoiceSupplement == null) {
            throw new NullPointerException("stageInvoiceSupplement is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        StageInvoiceSupplementUpdateItem updateItem = updateBucket.getUpdateItem();
        stageInvoiceSupplement.setName(StringUtils.trimToEmpty((String)updateItem.getName()));
        stageInvoiceSupplement.setPercent((BigDecimal)MoreObjects.firstNonNull((Object)updateItem.getPercent(), (Object)BigDecimal.ZERO));
        return stageInvoiceSupplement;
    }

    @Nonnull
    public List<StageInvoiceSupplementCommon> map(@NonNull Iterable<StageInvoiceSupplement> stageInvoiceSupplements) {
        if (stageInvoiceSupplements == null) {
            throw new NullPointerException("stageInvoiceSupplements is marked non-null but is null");
        }
        return (List)Streams.stream(stageInvoiceSupplements).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public StageInvoiceSupplementCommon map(@NonNull StageInvoiceSupplement stageInvoiceSupplement) {
        if (stageInvoiceSupplement == null) {
            throw new NullPointerException("stageInvoiceSupplement is marked non-null but is null");
        }
        StageInvoiceSupplementCommon common = new StageInvoiceSupplementCommon();
        BaseMapper.map((EntityBase)stageInvoiceSupplement, (EntityBaseCommon)common);
        common.setId(stageInvoiceSupplement.getId());
        common.setName(stageInvoiceSupplement.getName());
        common.setPercent(stageInvoiceSupplement.getPercent());
        return common;
    }

    public StageInvoiceSupplementMapper(AuthenticationHelper authenticationHelper, EntityFactory entityFactory) {
        this.authenticationHelper = authenticationHelper;
        this.entityFactory = entityFactory;
    }
}

