/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.quotation.AddendumDiscountCommon;
import de.qfm.erp.common.response.quotation.QuotationCommon;
import de.qfm.erp.common.response.quotation.QuotationPageCommon;
import de.qfm.erp.common.response.search.StageSearchItem;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.internal.quotation.EQuotationFlag;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.search.StageSearchItemBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.StageIndexEntry;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.mapper.QuotationPositionMapper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class QuotationMapper {
    private static final Logger log = LogManager.getLogger(QuotationMapper.class);
    private final MessageService messageService;
    private final UserService userService;
    private final HighlightMapper highlightMapper;
    private final QuotationPositionMapper quotationPositionMapper;
    private final ConfigService configService;
    private final CompanyConfig companyConfig;

    @Nonnull
    public QuotationCommon mapToCommon(@NonNull QuotationBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        return this.map(bucket);
    }

    @Nonnull
    private QuotationCommon map(@NonNull QuotationBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        Quotation item = bucket.getQuotation();
        QuotationCommon common = new QuotationCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setReferenceId(item.getReferenceId());
        common.setQuotationPositions(this.quotationPositionMapper.mapPositionItemToCommon(bucket));
        Iterable addendumDiscounts = bucket.getAddendumDiscounts();
        List addendumDiscountsCommon = (List)IterableHelper.stream((Iterable)addendumDiscounts).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        common.setAddendumDiscounts(addendumDiscountsCommon);
        common.setQuotationName(item.getQuotationName());
        common.setQuotationNumber(item.getQuotationNumber());
        common.setAddendumNumber(item.getAddendumNumber());
        common.setContactPerson(item.getContactPersonOld());
        common.setQuotationDate(item.getQuotationDate());
        common.setQuotationOpeningDate(item.getQuotationOpeningDate());
        common.setOrderDate(item.getOrderDate());
        common.setOrderNumber(item.getOrderNumber());
        common.setOrderDescription(item.getOrderDescription());
        common.setProjectExecutionStartDate(item.getProjectExecutionStartDate());
        common.setProjectExecutionEndDate(item.getProjectExecutionEndDate());
        common.setQuotationProjectExecutionStartDate(item.getQuotationProjectExecutionStartDate());
        common.setQuotationProjectExecutionEndDate(item.getQuotationProjectExecutionEndDate());
        common.setAccountingFlag(item.getAccountingFlag());
        common.setAccountingText(item.getAccountingText());
        common.setCostCenterInternal(item.getCostCenterInternal());
        common.setCostCenterExternal(item.getCostCenterExternal());
        common.setCustomerEmail(item.getCustomerEmail());
        Customer agent = item.getAgent();
        if (null != agent) {
            common.setAgentId(agent.getId());
        }
        common.setAgentShortName(item.getAgentShortName());
        common.setAgentName1(item.getAgentName1());
        common.setAgentName2(item.getAgentName2());
        common.setAgentStreet(item.getAgentStreet());
        common.setAgentCity(item.getAgentCity());
        common.setAgentZipCode(item.getAgentZipCode());
        Customer agentInvoice = item.getAgentInvoice();
        if (null != agentInvoice) {
            common.setAgentInvoiceId(agentInvoice.getId());
        }
        common.setAgentInvoiceShortName(item.getAgentInvoiceShortName());
        common.setAgentInvoiceName1(item.getAgentInvoiceName1());
        common.setAgentInvoiceName2(item.getAgentInvoiceName2());
        common.setAgentInvoiceStreet(item.getAgentInvoiceStreet());
        common.setAgentInvoiceCity(item.getAgentInvoiceCity());
        common.setAgentInvoiceZipCode(item.getAgentInvoiceZipCode());
        Customer customer = item.getCustomer();
        if (null != customer) {
            common.setCustomerId(customer.getId());
        }
        common.setCustomerShortName(item.getCustomerShortName());
        common.setCustomerName1(item.getCustomerName1());
        common.setCustomerName2(item.getCustomerName2());
        common.setCustomerStreet(item.getCustomerStreet());
        common.setCustomerZipCode(item.getCustomerZipCode());
        common.setCustomerCity(item.getCustomerCity());
        Customer customerInvoice = item.getCustomerInvoice();
        if (null != customerInvoice) {
            common.setCustomerInvoiceId(customerInvoice.getId());
        }
        common.setCustomerInvoiceShortName(item.getCustomerInvoiceShortName());
        common.setCustomerInvoiceName1(item.getCustomerInvoiceName1());
        common.setCustomerInvoiceName2(item.getCustomerInvoiceName2());
        common.setCustomerInvoiceStreet(item.getCustomerInvoiceStreet());
        common.setCustomerInvoiceZipCode(item.getCustomerInvoiceZipCode());
        common.setCustomerInvoiceCity(item.getCustomerInvoiceCity());
        common.setHeadlineG1(item.getHeadlineG1());
        common.setHeadlineG2(item.getHeadlineG2());
        common.setHeadlineG3(item.getHeadlineG3());
        common.setHeadlineG4(item.getHeadlineG4());
        common.setFlagConstantCompanyWage(item.getFlagConstantCompanyWage());
        common.setFlagOrderEnd(item.getFlagOrderEnd());
        common.setFlagOrderEqualsQuotation(item.getFlagOrderEqualsQuotation());
        common.setFlagSquadIsAllowedToCreateReleaseOrder(item.getFlagSquadIsAllowedToCreateReleaseOrder());
        common.setFlagMeasurementWithoutCommissionNumberAllowed(item.getFlagMeasurementWithoutCommissionNumberAllowed());
        common.setFlagReleaseOrderOrderNumberMandatory(item.getFlagReleaseOrderOrderNumberMandatory());
        common.setFlagAutomaticWageAssignmentAllowed(item.getFlagAutomaticWageAssignmentAllowed());
        common.setFinanceCompanyNumber(item.getFinanceCompanyNumber());
        common.setFinanceAccountingText(item.getFinanceAccountingText());
        common.setFinanceTimeForPayment(item.getFinanceTimeForPayment());
        common.setFinanceCashDiscountTime1(item.getFinanceCashDiscountTime1());
        common.setFinanceCashDiscount1(item.getFinanceCashDiscount1());
        common.setFinanceCashDiscountTime2(item.getFinanceCashDiscountTime2());
        common.setFinanceCashDiscount2(item.getFinanceCashDiscount2());
        common.setFinanceDebtorAccountNumber(item.getFinanceDebtorAccountNumber());
        common.setFinanceCostUnit(item.getFinanceCostUnit());
        common.setFinanceRoutingReferenceId(item.getFinanceRoutingReferenceId());
        TaxKey financeTaxKey = item.getFinanceTaxKey();
        if (null != financeTaxKey) {
            common.setFinanceTaxKeyId(financeTaxKey.getId());
        }
        common.setFinanceTaxKey(item.getFinanceTaxKeyValue());
        common.setFinanceAccount(item.getFinanceAccount());
        common.setFinanceVAT(item.getVatPercent());
        common.setFinanceRoutingReferenceId(item.getFinanceRoutingReferenceId());
        common.setGeneralDiscount(item.getGeneralDiscount());
        common.setOtherDiscount(item.getOtherDiscount());
        boolean hasHeadValePrivilege = this.userService.hasPrivilege(EPrivilege.QUOTATION__ALL_ATTRIBUTES_VISIBLE);
        if (hasHeadValePrivilege) {
            common.setValueAggregated(item.getValueAggregated());
            common.setMaterialValueAggregated(item.getMaterialValueAggregated());
            common.setPriceAggregated(item.getPriceAggregated());
            common.setOrderValueEstimate(item.getOrderValueEstimate());
            common.setMaterialPercentageMin(item.getMaterialPercentageMin());
            common.setMaterialPercentageStandard(item.getMaterialPercentageStandard());
            common.setWageFactorMin(item.getWageFactorMin());
            common.setWageFactorMax(item.getWageFactorMax());
            common.setWageValueAggregated(item.getWageValueAggregated());
        }
        ImmutableList hintNames = ImmutableList.copyOf(IterableHelper.stream((Iterable)bucket.getHints()).map(Enum::name).iterator());
        common.setHints((List)hintNames);
        HashSet allQuotationFlags = Sets.newHashSet();
        if (Boolean.TRUE == item.getFlagB2B()) {
            allQuotationFlags.add(EQuotationFlag.B2B);
        }
        if (Boolean.TRUE == item.getFlagOrderEnd()) {
            allQuotationFlags.add(EQuotationFlag.ORDER_END);
        }
        if (Boolean.TRUE == item.getFlagOrderEqualsQuotation()) {
            allQuotationFlags.add(EQuotationFlag.ORDER_EQUALS_QUOTATION);
        }
        if (Boolean.TRUE == item.getFlagMeasurementWithoutCommissionNumberAllowed()) {
            allQuotationFlags.add(EQuotationFlag.MEASUREMENT_WITHOUT_COMMISSION_ALLOWED);
        }
        ImmutableList flagNames = ImmutableList.copyOf(IterableHelper.stream((Iterable)allQuotationFlags).map(Enum::name).iterator());
        common.setFlags((List)flagNames);
        return common;
    }

    @Nonnull
    public QuotationPageCommon mapPageToCommon(@NonNull Page<Quotation> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = page.getContent();
        ImmutableList itemsCommon = ImmutableList.copyOf(content.stream().map((? super T item) -> this.mapToCommon(QuotationBucket.of((ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, (EQuotationPositionSortOption)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC, (Quotation)item, (String)"", (String)"", (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of()))).iterator());
        return new QuotationPageCommon(pageNumber, pageSize, totalPages, totalElements, (List)itemsCommon);
    }

    @Nonnull
    private AddendumDiscountCommon map(@NonNull AddendumDiscount entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        AddendumDiscountCommon common = new AddendumDiscountCommon();
        BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)entity.getGeneralDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)entity.getOtherDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal discount = generalDiscount.add(otherDiscount);
        common.setAddendumNumber(entity.getAddendumNumber().longValue());
        common.setDiscount(discount);
        return common;
    }

    @Nonnull
    public PageCommon<StageSearchItem> mapToSearchItem(Page<StageSearchItemBucket> bucketPage) {
        return BaseMapper.map(bucketPage, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public StageSearchItem mapToSearchItem(@NonNull StageSearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        StageIndexEntry stage = bucket.getStageIndexEntry();
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)stage.getStageType(), (Object)EQStageType.UNKNOWN);
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        String stageNumber = stage.getStageNumber();
        Integer stageVersion = stage.getVersion();
        String stageVersionText = null != stageVersion ? String.format(" V%s", stageVersion) : "";
        String effectiveStageNumber = StringUtils.isNotBlank((CharSequence)stageNumber) ? stageNumber + stageVersionText : StringUtils.trimToEmpty((String)stage.getStageAlias()) + stageVersionText;
        return StageSearchItem.of((long)stage.getId(), (String)effectiveStageNumber, (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon, (Long)stage.getEntityId(), (String)stageType.name());
    }

    public QuotationMapper(MessageService messageService, UserService userService, HighlightMapper highlightMapper, QuotationPositionMapper quotationPositionMapper, ConfigService configService, CompanyConfig companyConfig) {
        this.messageService = messageService;
        this.userService = userService;
        this.highlightMapper = highlightMapper;
        this.quotationPositionMapper = quotationPositionMapper;
        this.configService = configService;
        this.companyConfig = companyConfig;
    }
}

