/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.queue.QueueItemCommon;
import de.qfm.erp.common.response.queue.QueueItemListCommon;
import de.qfm.erp.service.model.jpa.queue.QueueItem;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class QueueMapper {
    @Nonnull
    public QueueItemListCommon map(int requestedSize, @NonNull Iterable<QueueItem> queueItems) {
        if (queueItems == null) {
            throw new NullPointerException("queueItems is marked non-null but is null");
        }
        ImmutableList queueItemsCommon = ImmutableList.copyOf(IterableHelper.stream(queueItems).map(arg_0 -> this.map(arg_0)).iterator());
        return new QueueItemListCommon(requestedSize, (List)queueItemsCommon);
    }

    @Nonnull
    public QueueItemCommon map(@NonNull QueueItem queueItem) {
        if (queueItem == null) {
            throw new NullPointerException("queueItem is marked non-null but is null");
        }
        QueueItemCommon queueItemCommon = new QueueItemCommon();
        queueItemCommon.setId((long)queueItem.getId());
        queueItemCommon.setQueueItemType(queueItem.getQueueItemType().name());
        queueItemCommon.setReferenceType(queueItem.getReferenceType().name());
        queueItemCommon.setReferenceId(queueItem.getReferenceId());
        return queueItemCommon;
    }
}

