/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.exception.request.InconsistentDataException;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.UserPrintInfo;
import de.qfm.erp.service.model.internal.print.qentity.EStagePrintFeature;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintRow;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintInfo;
import de.qfm.erp.service.model.internal.quotation.EStagePositionSortOption;
import de.qfm.erp.service.model.internal.quotation.StagePositionGroup;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.SurrogatePositionNumberHelper;
import de.qfm.erp.service.service.mapper.QStagePrintMapper;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QStagePrintMapper {
    private static final Logger log = LogManager.getLogger(QStagePrintMapper.class);
    static final int SIGNATURE_FILLUP_FROM_RESPONSIBLE_UP_TO = 2;
    static final Map<String, Integer> WEIGHT = ImmutableMap.of((Object)"gf", (Object)0, (Object)"ppa.", (Object)1, (Object)"i.v.", (Object)2, (Object)"i.a.", (Object)3);
    private static final Comparator<QuotationPosition> POS_NUMBER_COMPARATOR = Comparator.comparing(QuotationPosition::getPositionNumber, Comparator.nullsLast(Comparator.naturalOrder()));
    private static final Comparator<QuotationPosition> SEQ_NUMBER_COMPARATOR = Comparator.comparing(QuotationPosition::getSequenceNumberQuotationStandard, Comparator.nullsLast(Comparator.naturalOrder()));

    @Nonnull
    public QStagePrintInfo stagePrintInfo(@NonNull ConfigurationCompany sender, @NonNull Quotation stage, @NonNull User printedByUser, @NonNull Supplier<LocalDate> submissionOfBidDateSupplier, @NonNull Iterable<EStagePrintFeature> printFeatures, @NonNull Function<Quotation, List<QStagePositionPrintGroup>> groupFunction) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (printedByUser == null) {
            throw new NullPointerException("printedByUser is marked non-null but is null");
        }
        if (submissionOfBidDateSupplier == null) {
            throw new NullPointerException("submissionOfBidDateSupplier is marked non-null but is null");
        }
        if (printFeatures == null) {
            throw new NullPointerException("printFeatures is marked non-null but is null");
        }
        if (groupFunction == null) {
            throw new NullPointerException("groupFunction is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        QStagePrintInfo printInfo = new QStagePrintInfo();
        printInfo.setCurrency(Currency.getInstance(Locale.GERMANY));
        printInfo.setStagePrintFeatures((Iterable)ImmutableSet.copyOf(printFeatures));
        QEntity entity = stage.getQEntity();
        String entityNumber = null != entity ? entity.getQNumber() : "";
        String stageNumber = stage.getQNumber();
        String alias = stage.getAlias();
        printInfo.setEntityNumber(StringUtils.trimToEmpty((String)entityNumber));
        printInfo.setStageNumber(StringUtils.trimToEmpty((String)stageNumber));
        printInfo.setAlias(StringUtils.trimToEmpty((String)alias));
        printInfo.setName(StringUtils.trimToEmpty((String)stage.getQuotationName()));
        printInfo.setCoverLetterSubject1st(StringUtils.trimToEmpty((String)stage.getCoverLetterSubject1st()));
        printInfo.setCoverLetterSubject2nd(StringUtils.trimToEmpty((String)stage.getCoverLetterSubject2nd()));
        printInfo.setCoverLetterTitle(StringUtils.trimToEmpty((String)stage.getCoverLetterTitle()));
        printInfo.setCoverLetterBody1(StringUtils.trimToEmpty((String)stage.getCoverLetterBody1()));
        printInfo.setCoverLetterBody2(StringUtils.trimToEmpty((String)stage.getCoverLetterBody2()));
        printInfo.setCoverLetterBody3(StringUtils.trimToEmpty((String)stage.getCoverLetterBody3()));
        Customer customer = stage.getCustomer();
        if (null != customer) {
            String customerNumber = StringUtils.trimToEmpty((String)customer.getDebtorAccountNumber());
            printInfo.setCustomerNumber(customerNumber);
        }
        Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        ImmutableList.Builder contactPersonsBuilder = ImmutableList.builder();
        if (!Iterables.isEmpty((Iterable)stageResponsibleUsers)) {
            for (StageResponsibleUser stageResponsibleUser : stageResponsibleUsers) {
                User user = stageResponsibleUser.getUser();
                if (null == user) continue;
                String salutation = StringUtils.trimToEmpty((String)user.getSalutation());
                String fullName = StringUtils.trimToEmpty((String)user.getFullName());
                String name = StringUtils.joinWith((String)" ", (Object[])new Object[]{salutation, fullName});
                contactPersonsBuilder.add((Object)name);
            }
        }
        ImmutableList contactPersons = contactPersonsBuilder.build();
        printInfo.setContactPersons((Iterable)contactPersons);
        printInfo.setInquiryDate(stage.getInquiryDate());
        printInfo.setQuotationDate(stage.getQuotationDate());
        printInfo.setCommissionDate(stage.getCommissionDate());
        printInfo.setBindingPeriodDate(stage.getBindingPeriodDate());
        printInfo.setOrderDescriptionCustomer(StringUtils.trimToEmpty((String)stage.getOrderDescriptionCustomer()));
        printInfo.setOrderDescriptionInternal(StringUtils.trimToEmpty((String)stage.getOrderDescriptionInternal()));
        printInfo.setProcurementNumber(StringUtils.trimToEmpty((String)stage.getProcurementNumber()));
        printInfo.setFinanceTimeForPayment((Integer)MoreObjects.firstNonNull((Object)stage.getFinanceTimeForPayment(), (Object)0));
        printInfo.setFinanceCashDiscountTime1(stage.getFinanceCashDiscountTime1());
        printInfo.setFinanceCashDiscount1((BigDecimal)MoreObjects.firstNonNull((Object)stage.getFinanceCashDiscount1(), (Object)BigDecimal.ZERO));
        printInfo.setFinanceCashDiscountTime2(stage.getFinanceCashDiscountTime2());
        printInfo.setFinanceCashDiscount2((BigDecimal)MoreObjects.firstNonNull((Object)stage.getFinanceCashDiscount2(), (Object)BigDecimal.ZERO));
        printInfo.setStageType(stageType);
        printInfo.setProjectExecutionStartDate(stage.getProjectExecutionStartDate());
        printInfo.setProjectExecutionEndDate(stage.getProjectExecutionEndDate());
        CompanyPrintInfo senderCompanyInfo = this.sender(sender);
        printInfo.setSenderPrintInfo(senderCompanyInfo);
        CompanyPrintInfo recipient = this.recipient(stage);
        printInfo.setRecipientPrintInfo(recipient);
        List responsibleUserPrintInfos = this.responsibleUserPrintInfos(stage);
        printInfo.setResponsiblePrintInfos((Iterable)responsibleUserPrintInfos);
        List signaturePrintInfos = this.signaturePrintInfos(stage);
        printInfo.setSignaturePrintInfos((Iterable)signaturePrintInfos);
        List<QStagePositionPrintGroup> printGroups = groupFunction.apply(stage);
        printInfo.setPositionPrintGroups(printGroups);
        BigDecimal financeVAT = QStagePrintMapper.safeBD((BigDecimal)stage.getVatPercent());
        printInfo.setFinanceVAT(financeVAT);
        BigDecimal priceWithoutDiscountSum = QStagePrintMapper.safeBD((BigDecimal)stage.getPriceWithoutDiscountSum());
        printInfo.setPriceWithoutDiscountSum(priceWithoutDiscountSum);
        BigDecimal vatValueWithoutDiscountSum = QStagePrintMapper.safeBD((BigDecimal)stage.getVatValueWithoutDiscountSum());
        printInfo.setVatValueWithoutDiscountSum(vatValueWithoutDiscountSum);
        BigDecimal priceGrossWithoutDiscountSum = QStagePrintMapper.safeBD((BigDecimal)stage.getPriceGrossWithoutDiscountSum());
        printInfo.setPriceGrossWithoutDiscountSum(priceGrossWithoutDiscountSum);
        BigDecimal generalDiscount = QStagePrintMapper.safeBD((BigDecimal)stage.getGeneralDiscount());
        BigDecimal otherDiscount = QStagePrintMapper.safeBD((BigDecimal)stage.getOtherDiscount());
        BigDecimal discount = generalDiscount.add(otherDiscount);
        printInfo.setDiscount(discount);
        BigDecimal priceWithDiscountSum = QStagePrintMapper.safeBD((BigDecimal)stage.getPriceWithDiscountSum());
        printInfo.setPriceWithDiscountSum(priceWithDiscountSum);
        BigDecimal vatValueWithDiscountSum = QStagePrintMapper.safeBD((BigDecimal)stage.getVatValueWithDiscountSum());
        printInfo.setVatValueWithDiscountSum(vatValueWithDiscountSum);
        BigDecimal priceGrossWithDiscountSum = QStagePrintMapper.safeBD((BigDecimal)stage.getPriceGrossWithDiscountSum());
        printInfo.setPriceGrossWithDiscountSum(priceGrossWithDiscountSum);
        BigDecimal squadWageSum = QStagePrintMapper.safeBD((BigDecimal)stage.getSquadWageSum());
        printInfo.setSquadWageSum(squadWageSum);
        BigDecimal companyWageSum = QStagePrintMapper.safeBD((BigDecimal)stage.getCompanyWageSum());
        printInfo.setCompanyWageSum(companyWageSum);
        BigDecimal materialPurchasePriceSum = QStagePrintMapper.safeBD((BigDecimal)stage.getMaterialPurchasePriceSum());
        printInfo.setMaterialPurchasePriceSum(materialPurchasePriceSum);
        BigDecimal materialSellingPriceSum = QStagePrintMapper.safeBD((BigDecimal)stage.getMaterialSellingPriceSum());
        printInfo.setMaterialSellingPriceSum(materialSellingPriceSum);
        BigDecimal externalServicePurchasePriceSum = QStagePrintMapper.safeBD((BigDecimal)stage.getExternalServicePurchasePriceSum());
        printInfo.setExternalServicePurchasePriceSum(externalServicePurchasePriceSum);
        BigDecimal externalServiceSellingPriceSum = QStagePrintMapper.safeBD((BigDecimal)stage.getExternalServiceSellingPriceSum());
        printInfo.setExternalServiceSellingPriceSum(externalServiceSellingPriceSum);
        BigDecimal wagePercentageWeightedAverage = QStagePrintMapper.safeBD((BigDecimal)stage.getWagePercentageWeightedAverage());
        printInfo.setWagePercentageWeightedAverage(wagePercentageWeightedAverage);
        BigDecimal materialPercentageWeightedAverage = QStagePrintMapper.safeBD((BigDecimal)stage.getMaterialPercentageWeightedAverage());
        printInfo.setMaterialPercentageWeightedAverage(materialPercentageWeightedAverage);
        BigDecimal externalServicePercentageWeightedAverage = QStagePrintMapper.safeBD((BigDecimal)stage.getExternalServicePercentageWeightedAverage());
        printInfo.setExternalServicePercentageWeightedAverage(externalServicePercentageWeightedAverage);
        LocalDate submissionOfBidDate = (LocalDate)MoreObjects.firstNonNull((Object)submissionOfBidDateSupplier.get(), (Object)DateTimeHelper.today());
        printInfo.setSubmissionOfBidDate(submissionOfBidDate);
        printInfo.setPrintedByUserId(printedByUser.getId());
        printInfo.setPrintedByUserFullName(printedByUser.getFullName());
        printInfo.setPrintedByUserPhone(printedByUser.getPhone());
        printInfo.setPrintedByUserCellular(printedByUser.getCellular());
        printInfo.setPrintedByUserEMail(printedByUser.getEmail());
        return printInfo;
    }

    @Nonnull
    private List<UserPrintInfo> responsibleUserPrintInfos(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        Set responsibleUserPrintInfos = (Set)MoreObjects.firstNonNull((Object)quotation.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        ImmutableList.Builder signaturePrintInfoBuilder = ImmutableList.builder();
        for (StageResponsibleUser responsibleUser : responsibleUserPrintInfos) {
            User user = responsibleUser.getUser();
            if (null == user) continue;
            UserPrintInfo userPrintInfo = QStagePrintMapper.userPrintInfo((User)user);
            signaturePrintInfoBuilder.add((Object)userPrintInfo);
        }
        return signaturePrintInfoBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    List<UserPrintInfo> signaturePrintInfos(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        HashSet addedUserIds = Sets.newHashSet();
        Set stageSignatureUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageSignatureUsers(), (Object)ImmutableSet.of());
        ImmutableList.Builder signaturePrintInfoBuilder = ImmutableList.builder();
        for (StageSignatureUser stageSignatureUser : stageSignatureUsers) {
            User user = stageSignatureUser.getUser();
            if (null == user) continue;
            addedUserIds.add(user.getId());
            UserPrintInfo userPrintInfo = QStagePrintMapper.userPrintInfo((User)user);
            signaturePrintInfoBuilder.add((Object)userPrintInfo);
        }
        if (addedUserIds.size() < 2) {
            Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
            for (StageResponsibleUser stageResponsibleUser : stageResponsibleUsers) {
                User user = stageResponsibleUser.getUser();
                if (null == user || addedUserIds.contains(user.getId())) continue;
                addedUserIds.add(user.getId());
                UserPrintInfo userPrintInfo = QStagePrintMapper.userPrintInfo((User)user);
                signaturePrintInfoBuilder.add((Object)userPrintInfo);
                if (addedUserIds.size() < 2) continue;
                break;
            }
        }
        ImmutableList signaturePrintInfoUnsorted = signaturePrintInfoBuilder.build();
        return ImmutableList.sortedCopyOf((Comparator)new SignatureComparator(), (Iterable)signaturePrintInfoUnsorted);
    }

    @Nonnull
    private static UserPrintInfo userPrintInfo(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        String authorityToSign = StringUtils.trimToEmpty((String)user.getAuthorityToSign());
        String firstName = StringUtils.trimToEmpty((String)user.getFirstName());
        String lastName = StringUtils.trimToEmpty((String)user.getLastName());
        String fullName = StringUtils.trimToEmpty((String)user.getFullName());
        String phone = StringUtils.trimToEmpty((String)user.getPhone());
        String cellular = StringUtils.trimToEmpty((String)user.getCellular());
        String email = StringUtils.trimToEmpty((String)user.getEmail());
        return UserPrintInfo.of((String)firstName, (String)lastName, (String)fullName, (String)authorityToSign, (String)phone, (String)cellular, (String)email);
    }

    @Nonnull
    private static BigDecimal safeBD(@Nullable BigDecimal value) {
        return (BigDecimal)MoreObjects.firstNonNull((Object)value, (Object)BigDecimal.ZERO);
    }

    @Nonnull
    public List<QStagePositionPrintGroup> printGroupsGrouped(@NonNull Quotation stage, boolean printChild) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Comparator stagePositionComparator = QStagePrintMapper.stagePositionComparator((Quotation)stage);
        Iterable positionGroups = QuotationHelper.positionGroups((Quotation)stage, (boolean)true, (boolean)false);
        ImmutableList.Builder stagePositionPrintGroupBuilder = ImmutableList.builder();
        for (StagePositionGroup item : positionGroups) {
            stagePositionPrintGroupBuilder.addAll((Iterable)this.printRows(item, 0, stagePositionComparator, printChild));
        }
        return stagePositionPrintGroupBuilder.build();
    }

    @Nonnull
    public List<QStagePositionPrintGroup> printGroupsUngrouped(@NonNull Quotation stage, boolean printChild) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Iterable positionsOriginal = (Iterable)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableSet.of());
        Comparator comparator = QStagePrintMapper.stagePositionComparator((Quotation)stage);
        ImmutableList positionsSorted = ImmutableList.sortedCopyOf((Comparator)comparator, (Iterable)positionsOriginal);
        ImmutableList.Builder printRowBuilder = ImmutableList.builder();
        for (QuotationPosition quotationPosition : positionsSorted) {
            QuotationPosition parent;
            EPositionType positionType = quotationPosition.getPositionType();
            if (!printChild && Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)positionType) && positionsSorted.contains((Object)(parent = quotationPosition.getParent()))) continue;
            QStagePositionPrintRow printRow = this.printRow(quotationPosition, printChild);
            printRowBuilder.add((Object)printRow);
        }
        ImmutableList printRows = printRowBuilder.build();
        return ImmutableList.of((Object)QStagePositionPrintGroup.of((boolean)false, (boolean)true, (int)0, (Long)0L, (String)"", (String)"", (String)"", (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (Iterable)printRows, (Iterable)ImmutableList.of()));
    }

    @Nonnull
    private static Comparator<QuotationPosition> stagePositionComparator(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EStagePositionSortOption stagePositionSortOption = stage.getStagePositionSortOption();
        return stagePositionSortOption == EStagePositionSortOption.AUTOMATIC ? POS_NUMBER_COMPARATOR : SEQ_NUMBER_COMPARATOR;
    }

    @Nonnull
    private ImmutableList<QStagePositionPrintGroup> printRows(@NonNull StagePositionGroup positionGroup, int level, @NonNull Comparator<QuotationPosition> positionsComparator, boolean printChild) {
        if (positionGroup == null) {
            throw new NullPointerException("positionGroup is marked non-null but is null");
        }
        if (positionsComparator == null) {
            throw new NullPointerException("positionsComparator is marked non-null but is null");
        }
        ImmutableList.Builder stagePositionPrintGroupBuilder = ImmutableList.builder();
        boolean generated = positionGroup.isGenerated();
        Long id = positionGroup.getId();
        String key = positionGroup.getKey();
        String shortText = StringUtils.trimToEmpty((String)positionGroup.getShortText());
        String longText = StringUtils.trimToEmpty((String)positionGroup.getLongText());
        ImmutableList positionsSorted = ImmutableList.sortedCopyOf(positionsComparator, (Iterable)positionGroup.getPositions());
        Map children = positionGroup.getChildren();
        BigDecimal squadWageSum = positionGroup.sumCascade(true, QuotationPosition::getSquadWageAggregated);
        BigDecimal companyWageSum = positionGroup.sumCascade(true, QuotationPosition::getCompanyWageAggregated);
        BigDecimal wageFactorWeightedAverage = squadWageSum.compareTo(BigDecimal.ZERO) != 0 ? companyWageSum.divide(squadWageSum, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal materialPurchasePriceSum = positionGroup.sumCascade(true, QuotationPosition::getMaterialWholesalePriceIncludingDiscountAggregated);
        BigDecimal materialSellingPriceSum = positionGroup.sumCascade(true, QuotationPosition::getMaterialSellingPriceAggregated);
        BigDecimal materialFactorWeightedAverage = materialPurchasePriceSum.compareTo(BigDecimal.ZERO) != 0 ? materialSellingPriceSum.divide(materialPurchasePriceSum, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal externalServicePurchasePriceSum = positionGroup.sumCascade(true, QuotationPosition::getExternalServicePurchasePriceAggregated);
        BigDecimal externalServiceSellingPriceSum = positionGroup.sumCascade(true, QuotationPosition::getExternalServiceSellingPriceAggregated);
        BigDecimal externalServiceFactorWeightedAverage = externalServicePurchasePriceSum.compareTo(BigDecimal.ZERO) != 0 ? externalServiceSellingPriceSum.divide(externalServicePurchasePriceSum, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal discount = BigDecimal.ONE.negate();
        BigDecimal discountValueSum = BigDecimal.ONE.negate();
        BigDecimal priceWithoutDiscountSum = positionGroup.sumCascade(true, QuotationPosition::getPriceAggregated);
        BigDecimal priceWithDiscountSum = positionGroup.sumCascade(true, QuotationPosition::getPriceAggregated);
        List stagePositionPrintRows = this.printRows((Iterable)positionsSorted, false, false, printChild);
        ImmutableList.Builder childrenGroupsBuilder = ImmutableList.builder();
        TreeSet childKeys = Sets.newTreeSet((Iterable)((Iterable)MoreObjects.firstNonNull(children.keySet(), (Object)ImmutableSet.of())));
        for (String childKey : childKeys) {
            StagePositionGroup child = (StagePositionGroup)children.get(childKey);
            childrenGroupsBuilder.addAll((Iterable)this.printRows(child, level + 1, positionsComparator, printChild));
        }
        ImmutableList childrenGroups = childrenGroupsBuilder.build();
        QStagePositionPrintGroup positionPrintGroup = QStagePositionPrintGroup.of((boolean)true, (boolean)generated, (int)level, (Long)id, (String)key, (String)shortText, (String)longText, (BigDecimal)squadWageSum, (BigDecimal)wageFactorWeightedAverage, (BigDecimal)companyWageSum, (BigDecimal)materialPurchasePriceSum, (BigDecimal)materialFactorWeightedAverage, (BigDecimal)materialSellingPriceSum, (BigDecimal)externalServicePurchasePriceSum, (BigDecimal)externalServiceFactorWeightedAverage, (BigDecimal)externalServiceSellingPriceSum, (BigDecimal)discount, (BigDecimal)discountValueSum, (BigDecimal)priceWithoutDiscountSum, (BigDecimal)priceWithDiscountSum, (Iterable)stagePositionPrintRows, (Iterable)childrenGroups);
        stagePositionPrintGroupBuilder.add((Object)positionPrintGroup);
        return stagePositionPrintGroupBuilder.build();
    }

    @Nonnull
    private List<QStagePositionPrintRow> printRows(@NonNull Iterable<QuotationPosition> positionsOriginal, boolean hideZero, boolean groupPositions, boolean printChild) {
        if (positionsOriginal == null) {
            throw new NullPointerException("positionsOriginal is marked non-null but is null");
        }
        ImmutableList.Builder printRowsBuilder = ImmutableList.builder();
        for (QuotationPosition quotationPosition : positionsOriginal) {
            QuotationPosition parent;
            EPositionType positionType = quotationPosition.getPositionType();
            if (!printChild && Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)positionType) && Iterables.contains(positionsOriginal, (Object)(parent = quotationPosition.getParent()))) continue;
            QStagePositionPrintRow printRow = this.printRow(quotationPosition, printChild);
            BigDecimal product = (BigDecimal)MoreObjects.firstNonNull((Object)printRow.getOrderedAmount(), (Object)BigDecimal.ZERO);
            if (hideZero && BigDecimal.ZERO.compareTo(product) == 0) continue;
            printRowsBuilder.add((Object)printRow);
        }
        ImmutableList printRowsUnGrouped = printRowsBuilder.build();
        if (!groupPositions) {
            return printRowsUnGrouped;
        }
        ImmutableListMultimap byKey = Multimaps.index((Iterable)printRowsUnGrouped, QStagePositionPrintRow::getPositionNumber);
        ImmutableList.Builder printRowsGroupedBuilder = ImmutableList.builder();
        Set keys = byKey.keySet();
        for (String key : keys) {
            Collection stagePositionPrintRows = byKey.get((Object)key);
            if (Iterables.isEmpty((Iterable)stagePositionPrintRows)) continue;
            QStagePositionPrintRow identity = (QStagePositionPrintRow)Iterables.get((Iterable)stagePositionPrintRows, (int)0);
            if (Iterables.size((Iterable)stagePositionPrintRows) == 1) {
                printRowsGroupedBuilder.add((Object)identity);
                continue;
            }
            QStagePositionPrintRow combined = Streams.stream((Iterable)stagePositionPrintRows).reduce(QStagePositionPrintRow.empty(), QStagePositionPrintRow::combine);
            printRowsGroupedBuilder.add((Object)combined);
        }
        return printRowsGroupedBuilder.build();
    }

    @Nonnull
    private QStagePositionPrintRow printRow(@NonNull QuotationPosition originalPosition, boolean printChild) {
        BigDecimal priceAggregated;
        BigDecimal orderedAmount;
        QuotationPosition referencePosition;
        QuotationPosition parent;
        if (originalPosition == null) {
            throw new NullPointerException("originalPosition is marked non-null but is null");
        }
        EPositionType positionType = originalPosition.getPositionType();
        Object positionToBePrinted = printChild && Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)positionType) ? originalPosition : (!printChild && Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)positionType) ? (null != (parent = originalPosition.getParent()) ? parent : (null != (referencePosition = originalPosition.getReferencePosition()) ? referencePosition.getParent() : null)) : originalPosition);
        if (null == positionToBePrinted) {
            throw new InconsistentDataException(String.format("The Print Position could not be determined, indiciation: reference or parent is wrong - QuotationPosition.id: %s", originalPosition.getId()));
        }
        if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
            BigDecimal priceAggregatedOriginal;
            orderedAmount = priceAggregatedOriginal = originalPosition.getPriceAggregated();
            priceAggregated = priceAggregatedOriginal;
        } else {
            orderedAmount = positionToBePrinted.getOrderedAmount();
            priceAggregated = positionToBePrinted.getPriceAggregated();
        }
        QStagePositionPrintRow printRow = new QStagePositionPrintRow();
        QStagePrintMapper.applyInteger(() -> ((QuotationPosition)positionToBePrinted).getSequenceNumberQuotationStandard(), arg_0 -> ((QStagePositionPrintRow)printRow).setSequenceNumber(arg_0));
        printRow.setPositionType(positionType);
        boolean defaultFlagFormatBold = Iterables.contains((Iterable)EPositionType.PRINT_FORMAT_BOLD_DEFAULT, (Object)positionType);
        printRow.setFormatBoldFlag(((Boolean)MoreObjects.firstNonNull((Object)positionToBePrinted.getFlagFormatBold(), (Object)defaultFlagFormatBold)).booleanValue());
        printRow.setFormatColorFlag(((Boolean)MoreObjects.firstNonNull((Object)positionToBePrinted.getFlagFormatColor(), (Object)false)).booleanValue());
        printRow.setFormatColor(QStagePrintMapper.decodeColor((QuotationPosition)positionToBePrinted));
        QStagePrintMapper.applyString(() -> ((QuotationPosition)positionToBePrinted).getShortText(), arg_0 -> ((QStagePositionPrintRow)printRow).setShortText(arg_0));
        QStagePrintMapper.applyString(() -> ((QuotationPosition)positionToBePrinted).getLongText(), arg_0 -> ((QStagePositionPrintRow)printRow).setLongText(arg_0));
        String groupingLevel = SurrogatePositionNumberHelper.groupingLevel((QuotationPosition)positionToBePrinted);
        QStagePrintMapper.applyString(() -> groupingLevel, arg_0 -> ((QStagePositionPrintRow)printRow).setGroupingLevel(arg_0));
        if (Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) {
            printRow.setAlternativePositionType(positionToBePrinted.getAlternativePositionType());
            String positionNumber = SurrogatePositionNumberHelper.positionNumber((QuotationPosition)positionToBePrinted);
            QStagePrintMapper.applyString(() -> positionNumber, arg_0 -> ((QStagePositionPrintRow)printRow).setPositionNumber(arg_0));
            QStagePrintMapper.applyString(() -> ((QuotationPosition)positionToBePrinted).getUnit(), arg_0 -> ((QStagePositionPrintRow)printRow).setUnit(arg_0));
            QStagePrintMapper.applyString(() -> ((QuotationPosition)positionToBePrinted).getRemarks(), arg_0 -> ((QStagePositionPrintRow)printRow).setRemarks(arg_0));
            String bidderComplementTextOnly = StageHelper.bidderComplementTextOnly((QuotationPosition)positionToBePrinted);
            QStagePrintMapper.applyString(() -> bidderComplementTextOnly, arg_0 -> ((QStagePositionPrintRow)printRow).setBidderComplement(arg_0));
            String bidderComplementLongText = StageHelper.printBidderComplementLongText((QuotationPosition)positionToBePrinted);
            QStagePrintMapper.applyString(() -> bidderComplementLongText, arg_0 -> ((QStagePositionPrintRow)printRow).setLongText(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getSquadWagePerUnit(), arg_0 -> ((QStagePositionPrintRow)printRow).setSquadWagePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getSquadWageAggregated(), arg_0 -> ((QStagePositionPrintRow)printRow).setSquadWageAggregated(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getWagePercentage(), arg_0 -> ((QStagePositionPrintRow)printRow).setWagePercentage(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getCompanyWagePerItem(), arg_0 -> ((QStagePositionPrintRow)printRow).setCompanyWagePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getCompanyWageAggregated(), arg_0 -> ((QStagePositionPrintRow)printRow).setCompanyWageAggregated(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getMaterialWholesalePriceIncludingDiscountPerItem(), arg_0 -> ((QStagePositionPrintRow)printRow).setMaterialPurchasePricePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getMaterialWholesalePriceIncludingDiscountAggregated(), arg_0 -> ((QStagePositionPrintRow)printRow).setMaterialPurchasePriceAggregated(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getMaterialPercentage(), arg_0 -> ((QStagePositionPrintRow)printRow).setMaterialPercentage(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getMaterialSellingPricePerUnit(), arg_0 -> ((QStagePositionPrintRow)printRow).setMaterialSellingPricePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getMaterialSellingPriceAggregated(), arg_0 -> ((QStagePositionPrintRow)printRow).setMaterialSellingPriceAggregated(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getExternalServicePurchasePricePerUnit(), arg_0 -> ((QStagePositionPrintRow)printRow).setExternalServicePurchasePricePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getExternalServicePurchasePriceAggregated(), arg_0 -> ((QStagePositionPrintRow)printRow).setExternalServicePurchasePriceAggregated(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getExternalServicePercentage(), arg_0 -> ((QStagePositionPrintRow)printRow).setExternalServicePercentage(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getExternalServiceSellingPricePerUnit(), arg_0 -> ((QStagePositionPrintRow)printRow).setExternalServiceSellingPricePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getExternalServiceSellingPriceAggregated(), arg_0 -> ((QStagePositionPrintRow)printRow).setExternalServiceSellingPriceAggregated(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> ((QuotationPosition)positionToBePrinted).getPricePerUnit(), arg_0 -> ((QStagePositionPrintRow)printRow).setPricePerUnit(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> orderedAmount, arg_0 -> ((QStagePositionPrintRow)printRow).setOrderedAmount(arg_0));
            QStagePrintMapper.applyBigDecimal(() -> priceAggregated, arg_0 -> ((QStagePositionPrintRow)printRow).setPriceAggregated(arg_0));
        }
        return printRow;
    }

    @Nullable
    private static Color decodeColor(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        try {
            String formatColorCode = quotationPosition.getFormatColorCodeHex();
            return Color.decode(formatColorCode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nonnull
    private CompanyPrintInfo sender(@NonNull ConfigurationCompany configurationCompany) {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyName1(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyName2(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyStreetNo(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyZipCode(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        QStagePrintMapper.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyEmail(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerEmail(arg_0));
        return companyPrintInfo;
    }

    @Nonnull
    private CompanyPrintInfo recipient(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        Address address = quotation.getAddress();
        if (null != address) {
            QStagePrintMapper.applyString(() -> ((Address)address).getName(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
            QStagePrintMapper.applyString(() -> ((Address)address).getPoBox(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
            QStagePrintMapper.applyString(() -> ((Address)address).getAddressSuffix(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName3(arg_0));
            QStagePrintMapper.applyString(() -> ((Address)address).getStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
            QStagePrintMapper.applyString(() -> ((Address)address).getStreetNo(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
            QStagePrintMapper.applyString(() -> ((Address)address).getCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
            QStagePrintMapper.applyString(() -> ((Address)address).getZipCode(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        } else {
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName3(arg_0));
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
            QStagePrintMapper.applyString(() -> "", arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        }
        return companyPrintInfo;
    }

    private static void applyString(@NonNull Supplier<String> supplier, @NonNull Consumer<String> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(StringUtils.trimToEmpty((String)supplier.get()));
    }

    private static void applyInteger(@NonNull Supplier<Integer> supplier, @NonNull Consumer<Integer> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }

    private static void applyBigDecimal(@NonNull Supplier<BigDecimal> supplier, @NonNull Consumer<BigDecimal> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }
}

