/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.common.response.role.PrivilegeCommon;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.service.MessageService;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeMapper {
    private static Map<EPrivilege, PrivilegeCommon> PRIVILEGE_MAP = ImmutableMap.of();
    private final MessageService messageService;

    @PostConstruct
    public void initPrivilegeMap() {
        EPrivilege[] values;
        ImmutableMap.Builder privilegeMapBuilder = ImmutableMap.builder();
        for (EPrivilege value : values = EPrivilege.values()) {
            String descriptionEN = this.messageService.getEN(value);
            String descriptionDE = this.messageService.getDE(value);
            privilegeMapBuilder.put((Object)value, (Object)PrivilegeCommon.of((String)value.name(), (String)descriptionDE, (String)descriptionEN));
        }
        PRIVILEGE_MAP = privilegeMapBuilder.build();
        ImmutableList privilegeCommonList = ImmutableList.copyOf(PRIVILEGE_MAP.values());
    }

    @NonNull
    public PrivilegeCommon map(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        return (PrivilegeCommon)PRIVILEGE_MAP.get(privilege);
    }

    public PrivilegeMapper(MessageService messageService) {
        this.messageService = messageService;
    }
}

