/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportAuxiliaryPrintRow;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportIncentivePrintRow;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthReportSquadLeaderPrintRow;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthSlipItemPrintRow;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.PayrollPrintMapper;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PayrollPrintMapper {
    private final MessageService messageService;

    @Nonnull
    public Iterable<PayrollMonthSlipItemPrintRow> mapPayrollMonthSlipItemPrintRow(@NonNull Iterable<WageTypeCalculationResult> wageTypeCalculationResults) {
        if (wageTypeCalculationResults == null) {
            throw new NullPointerException("wageTypeCalculationResults is marked non-null but is null");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (WageTypeCalculationResult wageTypeCalculationResult : wageTypeCalculationResults) {
            PayrollItemType payrollItemType = wageTypeCalculationResult.getPayrollItemType();
            Boolean flagPrintRow = (Boolean)MoreObjects.firstNonNull((Object)payrollItemType.getFlagPrintRow(), (Object)Boolean.TRUE);
            if (!flagPrintRow.booleanValue()) continue;
            Long id = payrollItemType.getId();
            Integer order = (Integer)MoreObjects.firstNonNull((Object)wageTypeCalculationResult.getOrder(), (Object)-1);
            EWageTypeCalculationResultType wageTypeCalculationResultType = wageTypeCalculationResult.getWageTypeCalculationResultType();
            Boolean detailFlag = wageTypeCalculationResultType.detailFlag();
            String name = payrollItemType.getName();
            String description = wageTypeCalculationResult.getDescription();
            BigDecimal descriptionValue = wageTypeCalculationResult.getDescriptionValue();
            LaborUnionContract laborUnionContract = payrollItemType.getLaborUnionContract();
            Long laborUnionContractId = null != laborUnionContract ? laborUnionContract.getId() : null;
            String laborUnionContractName = null != laborUnionContract ? laborUnionContract.getName() : "";
            EPayrollItemUnit unit = (EPayrollItemUnit)MoreObjects.firstNonNull((Object)payrollItemType.getUnit(), (Object)EPayrollItemUnit.UNKNOWN);
            String unitTranslated = this.messageService.translate(unit.messageCode());
            Integer wageTypeNumber = payrollItemType.getWageTypeNumber();
            Boolean flagPrintTimes = detailFlag != false ? payrollItemType.getFlagPrintDetailTimes() : payrollItemType.getFlagPrintTimes();
            Boolean flagPrintFactor = detailFlag != false ? payrollItemType.getFlagPrintDetailFactor() : payrollItemType.getFlagPrintFactor();
            Boolean flagPrintValue = detailFlag != false ? payrollItemType.getFlagPrintDetailValue() : payrollItemType.getFlagPrintValue();
            BigDecimal times = Objects.equals(flagPrintTimes, Boolean.TRUE) ? wageTypeCalculationResult.getTimes() : null;
            BigDecimal factor = Objects.equals(flagPrintFactor, Boolean.TRUE) ? wageTypeCalculationResult.getFactor() : null;
            BigDecimal value = Objects.equals(flagPrintValue, Boolean.TRUE) ? wageTypeCalculationResult.getValue() : null;
            PayrollMonthSlipItemPrintRow payrollMonthSlipItemPrintRow = new PayrollMonthSlipItemPrintRow();
            payrollMonthSlipItemPrintRow.setId(id);
            payrollMonthSlipItemPrintRow.setSequenceNumber(order);
            payrollMonthSlipItemPrintRow.setDetailFlag(detailFlag);
            payrollMonthSlipItemPrintRow.setName(name);
            payrollMonthSlipItemPrintRow.setDescription(description);
            payrollMonthSlipItemPrintRow.setDescriptionValue(descriptionValue);
            payrollMonthSlipItemPrintRow.setTimes(times);
            payrollMonthSlipItemPrintRow.setFactor(factor);
            payrollMonthSlipItemPrintRow.setValue(value);
            payrollMonthSlipItemPrintRow.setLaborUnionContractId(laborUnionContractId);
            payrollMonthSlipItemPrintRow.setLaborUnionContractName(laborUnionContractName);
            payrollMonthSlipItemPrintRow.setUnit(unitTranslated);
            payrollMonthSlipItemPrintRow.setWageTypeNumber(wageTypeNumber);
            rowsBuilder.add((Object)payrollMonthSlipItemPrintRow);
        }
        return rowsBuilder.build();
    }

    @Nonnull
    public Iterable<PayrollMonthReportAuxiliaryPrintRow> mapPayrollMonthReportAuxiliaryPrintRow(@NonNull BigDecimal effectiveWagePerHour, @NonNull Iterable<PayrollMonthItem> auxiliaryWages) {
        if (effectiveWagePerHour == null) {
            throw new NullPointerException("effectiveWagePerHour is marked non-null but is null");
        }
        if (auxiliaryWages == null) {
            throw new NullPointerException("auxiliaryWages is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PayrollMonthItem auxiliaryWage : auxiliaryWages) {
            String senderCostCenter;
            YearMonth accountingMonth = YearMonth.from(auxiliaryWage.getPayrollMonth().getAccountingMonth());
            User sender = auxiliaryWage.getSender();
            Long senderId = null != sender ? sender.getId() : 0L;
            Integer senderPersonalNumber = null != sender ? sender.getPersonalNumber() : 0;
            String senderFullName = null != sender ? sender.getFullName() : "";
            String string = senderCostCenter = null != sender ? EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)accountingMonth.atDay(1)).orElse("n/a") : "";
            PayrollItemType payrollItemType = auxiliaryWage.getPayrollItemType();
            if (null == payrollItemType) continue;
            Long payrollItemTypeId = payrollItemType.getId();
            String payrollItemTypeName = payrollItemType.getName();
            EPayrollItemUnit payrollItemTypeUnit = payrollItemType.getUnit();
            BigDecimal factor = payrollItemType.getValue();
            String payrollItemTypeUnitText = this.messageService.getDE((Translatable)payrollItemTypeUnit, new Object[0]);
            BigDecimal amount = (BigDecimal)MoreObjects.firstNonNull((Object)auxiliaryWage.getValue(), (Object)BigDecimal.ZERO);
            BigDecimal value = amount.multiply(switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$employee$payroll$EPayrollItemUnit[payrollItemTypeUnit.ordinal()]) {
                case 1 -> (BigDecimal)MoreObjects.firstNonNull((Object)factor, (Object)BigDecimal.ONE);
                case 2 -> (BigDecimal)MoreObjects.firstNonNull((Object)effectiveWagePerHour, (Object)BigDecimal.ONE);
                case 3 -> BigDecimal.ONE;
                default -> BigDecimal.ONE;
            });
            String remarks = StringUtils.trimToEmpty((String)auxiliaryWage.getRemarks());
            builder.add((Object)PayrollMonthReportAuxiliaryPrintRow.of((Long)senderId, (Integer)senderPersonalNumber, (String)senderFullName, (String)senderCostCenter, (Long)payrollItemTypeId, (String)payrollItemTypeName, (String)payrollItemTypeUnitText, (BigDecimal)amount, (BigDecimal)value, (String)remarks));
        }
        return builder.build();
    }

    @Nonnull
    public Iterable<PayrollMonthReportIncentivePrintRow> mapPayrollMonthReportIncentivePrintRow(@NonNull Iterable<PayrollMonthItem> incentivePayrollMonthItems) {
        if (incentivePayrollMonthItems == null) {
            throw new NullPointerException("incentivePayrollMonthItems is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PayrollMonthItem incentiveWage : incentivePayrollMonthItems) {
            YearMonth accountingMonth = YearMonth.from(incentiveWage.getPayrollMonth().getAccountingMonth());
            User sender = incentiveWage.getSender();
            Long senderId = null != sender ? sender.getId() : 0L;
            Integer senderPersonalNumber = null != sender ? sender.getPersonalNumber() : 0;
            String senderFullName = null != sender ? sender.getFullName() : "";
            String senderCostCenter = null != sender ? EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)accountingMonth.atDay(1)).orElse("n/a") : "";
            User recipient = incentiveWage.getRecipient();
            Long recipientId = null != recipient ? recipient.getId() : 0L;
            Integer recipientPersonalNumber = null != recipient ? recipient.getPersonalNumber() : 0;
            String recipientFullName = null != recipient ? recipient.getFullName() : "";
            String recipientCostCenter = null != recipient ? EmployeeHelper.currentCostCenterNotFailing((User)recipient, (LocalDate)accountingMonth.atDay(1)).orElse("n/a") : "";
            String quotationNumber = StringUtils.trimToEmpty((String)incentiveWage.getQuotationNumber());
            BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)incentiveWage.getValue(), (Object)BigDecimal.ZERO);
            String remarks = StringUtils.trimToEmpty((String)incentiveWage.getRemarks());
            builder.add((Object)PayrollMonthReportIncentivePrintRow.of((Long)senderId, (Integer)senderPersonalNumber, (String)senderFullName, (String)senderCostCenter, (Long)recipientId, (Integer)recipientPersonalNumber, (String)recipientFullName, (String)recipientCostCenter, (String)quotationNumber, (BigDecimal)value, (String)remarks));
        }
        return builder.build();
    }

    @Nonnull
    public Iterable<PayrollMonthReportSquadLeaderPrintRow> mapPayrollMonthReportSquadLeaderPrintRow(@NonNull Iterable<Attendance> squadLeaderAttendances) {
        if (squadLeaderAttendances == null) {
            throw new NullPointerException("squadLeaderAttendances is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Attendance attendance : squadLeaderAttendances) {
            User sender = attendance.getPayrollMonth().getUser();
            Long senderId = null != sender ? sender.getId() : 0L;
            Integer senderPersonalNumber = null != sender ? sender.getPersonalNumber() : 0;
            String senderFullName = null != sender ? sender.getFullName() : "";
            String senderCostCenter = "TODO";
            LocalDate date = attendance.getDate();
            builder.add((Object)PayrollMonthReportSquadLeaderPrintRow.of((Long)senderId, (Integer)senderPersonalNumber, (String)senderFullName, (String)"TODO", (LocalDate)date, (BigDecimal)BigDecimal.ONE));
        }
        return builder.build();
    }

    public PayrollPrintMapper(MessageService messageService) {
        this.messageService = messageService;
    }
}

