/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import de.qfm.erp.common.request.generic.PayrollItemTypeUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypeCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypePageCommon;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.payroll.PayrollItemTypeUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.service.MessageService;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class PayrollItemTypeMapper {
    private final MessageService messageService;

    @Nonnull
    public PayrollItemTypeCommon map(@NonNull PayrollItemType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PayrollItemTypeCommon common = new PayrollItemTypeCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        LaborUnionContract laborUnionContract = item.getLaborUnionContract();
        if (null != laborUnionContract) {
            common.setLaborUnionContractId(laborUnionContract.getId());
            common.setLaborUnionContractName(laborUnionContract.getName());
        }
        common.setName(item.getName());
        EPayrollItemUnit unit = (EPayrollItemUnit)MoreObjects.firstNonNull((Object)item.getUnit(), (Object)EPayrollItemUnit.UNKNOWN);
        String unitAsString = unit.name();
        common.setUnit(unitAsString);
        common.setValue(item.getValue());
        common.setDescription(item.getDescription());
        common.setFlagDeductFromWage(item.getFlagDeductFromWage());
        common.setFlagVisibleInSelection(item.getFlagVisibleInSelection());
        EWageType safeWageType = (EWageType)MoreObjects.firstNonNull((Object)item.getWageType(), (Object)EWageType.NONE);
        String wageTypeString = safeWageType.name();
        common.setWageType(wageTypeString);
        common.setWageTypeNumber(item.getWageTypeNumber());
        common.setSequentialNumber(item.getSequentialNumber());
        EWageTypeCalculationResultType safeSbsWageTypeCalculationResultType = (EWageTypeCalculationResultType)MoreObjects.firstNonNull((Object)item.getSbsExportWageTypeCalculationResultType(), (Object)EWageTypeCalculationResultType.NONE);
        String sbsWageTypeCalculationResultTypeString = safeSbsWageTypeCalculationResultType.name();
        common.setSbsExportWageTypeCalculationResultType(sbsWageTypeCalculationResultTypeString);
        EWageTypeCalculationResultType safePrintWageTypeCalculationResultType = (EWageTypeCalculationResultType)MoreObjects.firstNonNull((Object)item.getPrintWageTypeCalculationResultType(), (Object)EWageTypeCalculationResultType.NONE);
        String printWageTypeCalculationResultTypeString = safePrintWageTypeCalculationResultType.name();
        common.setPrintWageTypeCalculationResultType(printWageTypeCalculationResultTypeString);
        common.setFlagPrintTimes((Boolean)MoreObjects.firstNonNull((Object)item.getFlagPrintTimes(), (Object)Boolean.FALSE));
        common.setFlagPrintFactor((Boolean)MoreObjects.firstNonNull((Object)item.getFlagPrintFactor(), (Object)Boolean.FALSE));
        common.setFlagPrintValue((Boolean)MoreObjects.firstNonNull((Object)item.getFlagPrintValue(), (Object)Boolean.FALSE));
        common.setFlagSBSExportTimes((Boolean)MoreObjects.firstNonNull((Object)item.getFlagSBSExportTimes(), (Object)Boolean.FALSE));
        common.setFlagSBSExportFactor((Boolean)MoreObjects.firstNonNull((Object)item.getFlagSBSExportFactor(), (Object)Boolean.FALSE));
        common.setFlagSBSExportValue((Boolean)MoreObjects.firstNonNull((Object)item.getFlagSBSExportValue(), (Object)Boolean.FALSE));
        common.setFlagRemarksMandatory((Boolean)MoreObjects.firstNonNull((Object)item.getFlagRemarksMandatory(), (Object)Boolean.FALSE));
        common.setFlagProjectMandatory((Boolean)MoreObjects.firstNonNull((Object)item.getFlagProjectMandatory(), (Object)Boolean.FALSE));
        PayrollItemType sbsValuePayrollItemType = item.getSbsValuePayrollItemType();
        if (null != sbsValuePayrollItemType) {
            common.setSbsValuePayrollItemTypeId(sbsValuePayrollItemType.getId());
            common.setSbsValuePayrollItemTypeName(sbsValuePayrollItemType.getName());
        }
        return common;
    }

    @Nonnull
    public PayrollItemTypePageCommon map(@NonNull Page<PayrollItemType> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (PayrollItemTypePageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PayrollItemTypePageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public PayrollItemType merge(@NonNull PayrollItemTypeUpdateBucket payrollItemTypeUpdateBucket) {
        if (payrollItemTypeUpdateBucket == null) {
            throw new NullPointerException("payrollItemTypeUpdateBucket is marked non-null but is null");
        }
        PayrollItemType payrollItemType = payrollItemTypeUpdateBucket.getPayrollItemType();
        PayrollItemTypeUpdateRequest request = payrollItemTypeUpdateBucket.getRequest();
        LaborUnionContract laborUnionContract = payrollItemTypeUpdateBucket.getLaborUnionContract();
        payrollItemType.setLaborUnionContract(laborUnionContract);
        PayrollItemType sbsValuePayrollItemType = payrollItemTypeUpdateBucket.getSbsValuePayrollItemType();
        payrollItemType.setSbsValuePayrollItemType(sbsValuePayrollItemType);
        payrollItemType.setName(StringUtils.trimToEmpty((String)request.getName()));
        payrollItemType.setDescription(StringUtils.trimToEmpty((String)request.getDescription()));
        payrollItemType.setValue(request.getValue());
        payrollItemType.setWageTypeNumber(request.getWageTypeNumber());
        payrollItemType.setSequentialNumber(request.getSequentialNumber());
        payrollItemType.setFlagVisibleInSelection(request.getFlagVisibleInSelection());
        payrollItemType.setFlagDeductFromWage(request.getFlagDeductFromWage());
        payrollItemType.setFlagPrintTimes(request.getFlagPrintTimes());
        payrollItemType.setFlagPrintFactor(request.getFlagPrintFactor());
        payrollItemType.setFlagPrintValue(request.getFlagPrintValue());
        payrollItemType.setFlagSBSExportTimes(request.getFlagSBSExportTimes());
        payrollItemType.setFlagSBSExportFactor(request.getFlagSBSExportFactor());
        payrollItemType.setFlagSBSExportValue(request.getFlagSBSExportValue());
        payrollItemType.setFlagRemarksMandatory(request.getFlagRemarksMandatory());
        payrollItemType.setUnit(payrollItemTypeUpdateBucket.getPayrollItemUnit());
        payrollItemType.setWageType(payrollItemTypeUpdateBucket.getWageType());
        payrollItemType.setPrintWageTypeCalculationResultType(payrollItemTypeUpdateBucket.getPrintWageTypeCalculationResultType());
        payrollItemType.setSbsExportWageTypeCalculationResultType(payrollItemTypeUpdateBucket.getSbsWageTypeCalculationResultType());
        return payrollItemType;
    }

    public PayrollItemTypeMapper(MessageService messageService) {
        this.messageService = messageService;
    }
}

