/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EInvoiceIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.InvoiceIndexEntry;
import de.qfm.erp.service.service.mapper.search.InvoiceIndexEntrySerializer;
import de.qfm.erp.service.service.service.ConfigService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvoiceSearchMapper {
    private static final Logger log = LogManager.getLogger(InvoiceSearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private final InvoiceIndexEntrySerializer invoiceIndexEntrySerializer;
    private final ConfigService configService;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull Invoice invoice, @NonNull EIndexEntryType indexEntryType) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(invoice, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<Invoice> invoices, @NonNull EIndexEntryType indexEntryType) {
        if (invoices == null) {
            throw new NullPointerException("invoices is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoices).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public InvoiceIndexEntry mapToIndexEntry(@NonNull Invoice invoice, @NonNull EIndexEntryType indexEntryType) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        InvoiceIndexEntry indexEntry = new InvoiceIndexEntry();
        indexEntry.setId(invoice.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(invoice.getCreatedOn());
        indexEntry.setCreatedBy(invoice.getCreatedBy());
        indexEntry.setUpdatedOn(invoice.getUpdatedOn());
        indexEntry.setUpdatedBy(invoice.getUpdatedBy());
        indexEntry.setEntityState(invoice.getEntityState());
        EInvoiceState invoiceState = invoice.getInvoiceState();
        indexEntry.setInvoiceState(invoiceState);
        LinkedHashSet measurementNumbers = Sets.newLinkedHashSet();
        for (InvoiceMeasurement invoiceMeasurement : invoice.getInvoiceMeasurements()) {
            String measurementNumber;
            Measurement measurement = invoiceMeasurement.getMeasurement();
            if (null == measurement || null == (measurementNumber = measurement.getMeasurementNumber())) continue;
            measurementNumbers.add(measurementNumber);
        }
        indexEntry.setMeasurementNumbers((List)ImmutableList.copyOf((Collection)measurementNumbers));
        Quotation stage = invoice.getQuotation();
        if (null != stage) {
            indexEntry.setStageId(stage.getId());
            indexEntry.setStageNumber(stage.getQNumber());
            indexEntry.setStageAlias(stage.getAlias());
            indexEntry.setQuotationNumber(stage.getQuotationNumber());
            QEntity entity = stage.getQEntity();
            if (null != entity) {
                indexEntry.setEntityId(entity.getId());
                indexEntry.setEntityNumber(entity.getQNumber());
                indexEntry.setEntityAlias(entity.getAlias());
            }
        }
        indexEntry.setInvoiceNumber(invoice.getInvoiceNumber());
        indexEntry.setCostCenter(invoice.getCostCenter());
        indexEntry.setContactPerson(invoice.getContactPerson());
        indexEntry.setOrderNumber(invoice.getOrderNumber());
        indexEntry.setVoucherNumber(invoice.getVoucherNumber());
        indexEntry.setCreditVoucherNumber(invoice.getCreditVoucherNumber());
        indexEntry.setConstructionSite(invoice.getConstructionSite());
        indexEntry.setOrderDescription(invoice.getOrderDescription());
        indexEntry.setInvoiceName(invoice.getInvoiceName());
        Address invoiceAddress = invoice.getInvoiceAddress();
        if (null != invoiceAddress) {
            indexEntry.setInvoiceAddressName(invoiceAddress.getName());
            indexEntry.setInvoiceAddressStreet(invoiceAddress.getStreet());
        }
        indexEntry.setInvoiceAddressSuffix(invoice.getInvoiceAddressSuffix());
        Address invoiceRefAddress = invoice.getInvoiceRefAddress();
        if (null != invoiceRefAddress) {
            indexEntry.setInvoiceRefAddressName(invoiceRefAddress.getName());
            indexEntry.setInvoiceRefAddressStreet(invoiceRefAddress.getStreet());
        }
        indexEntry.setInvoiceRefAddressSuffix(invoice.getInvoiceRefAddressSuffix());
        indexEntry.setImportFileName(invoice.getImportFileName());
        indexEntry.setFinanceDebtorAccountNumber(invoice.getFinanceDebtorAccountNumber());
        return indexEntry;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull InvoiceIndexEntry invoiceIndexEntry) {
        String source;
        Document document = new Document();
        String documentId = InvoiceSearchMapper.documentId((InvoiceIndexEntry)invoiceIndexEntry);
        String type = invoiceIndexEntry.getIndexEntryType().name();
        try {
            source = this.invoiceIndexEntrySerializer.serialize(invoiceIndexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)EInvoiceIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)EInvoiceIndexField.INVOICE__ID, (Long)invoiceIndexEntry.getId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EInvoiceIndexField.INVOICE__CREATED_ON, (LocalDateTime)invoiceIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EInvoiceIndexField.INVOICE__UPDATED_ON, (LocalDateTime)invoiceIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__CREATED_BY, (String)invoiceIndexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__UPDATED_BY, (String)invoiceIndexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        EntityState entityState = (EntityState)MoreObjects.firstNonNull((Object)invoiceIndexEntry.getEntityState(), (Object)EntityState.INVALID);
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__ENTITY_STATE, (String)entityState.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoiceIndexEntry.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_STATE, (String)invoiceState.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)invoiceIndexEntry.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_TYPE, (String)invoiceType.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)EInvoiceIndexField.INVOICE__STAGE_ID, (Long)invoiceIndexEntry.getStageId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)EInvoiceIndexField.INVOICE__ENTITY_ID, (Long)invoiceIndexEntry.getEntityId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__STAGE_NUMBER, (String)StringUtils.removeStart((String)invoiceIndexEntry.getStageNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__STAGE_NUMBER, (String)invoiceIndexEntry.getStageNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__STAGE_ALIAS, (String)invoiceIndexEntry.getStageAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__ENTITY_NUMBER, (String)StringUtils.removeStart((String)invoiceIndexEntry.getEntityNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__ENTITY_NUMBER, (String)invoiceIndexEntry.getEntityNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__ENTITY_ALIAS, (String)invoiceIndexEntry.getEntityAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__QUOTATION_NUMBER, (String)StringUtils.remove((String)invoiceIndexEntry.getQuotationNumber(), (String)"/")).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__QUOTATION_NUMBER, (String)invoiceIndexEntry.getQuotationNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_NUMBER, (String)InvoiceSearchMapper.removeInvoicePrefix((String)invoiceIndexEntry.getInvoiceNumber())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_NUMBER, (String)invoiceIndexEntry.getInvoiceNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__COST_CENTER, (String)invoiceIndexEntry.getCostCenter()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__CONTACT_PERSON, (String)invoiceIndexEntry.getContactPerson()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__ORDER_NUMBER, (String)invoiceIndexEntry.getOrderNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__CREDIT_VOUCHER_NUMBER, (String)invoiceIndexEntry.getCreditVoucherNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__CONSTRUCTION_SITE, (String)invoiceIndexEntry.getConstructionSite()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__ORDER_DESCRIPTION, (String)invoiceIndexEntry.getOrderDescription()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_NAME, (String)invoiceIndexEntry.getInvoiceName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_ADDRESS_NAME, (String)invoiceIndexEntry.getInvoiceAddressName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_ADDRESS_STREET, (String)invoiceIndexEntry.getInvoiceAddressStreet()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_ADDRESS_SUFFIX, (String)invoiceIndexEntry.getInvoiceAddressSuffix()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_REF_ADDRESS_NAME, (String)invoiceIndexEntry.getInvoiceRefAddressName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_REF_ADDRESS_STREET, (String)invoiceIndexEntry.getInvoiceRefAddressStreet()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__INVOICE_REF_ADDRESS_SUFFIX, (String)invoiceIndexEntry.getInvoiceRefAddressSuffix()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField.INVOICE__PRIMARY_RESPONSIBLE_USER__FULL_NAME, (String)invoiceIndexEntry.getPrimaryResponsibleFulLName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__FINANCE_DEBTOR_ACCOUNT_NUMBER, (String)invoiceIndexEntry.getFinanceDebtorAccountNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        List measurementNumbers = (List)MoreObjects.firstNonNull((Object)invoiceIndexEntry.getMeasurementNumbers(), (Object)ImmutableList.of());
        measurementNumbers.forEach(item -> LuceneHelper.notTokenized((IndexField)EInvoiceIndexField.INVOICE__MEASUREMENT_NUMBER, (String)item).ifPresent(arg_0 -> ((Document)document).add(arg_0)));
        String allFromDocument = InvoiceSearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)EInvoiceIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EInvoiceIndexField.SORT_INVOICE__CREATED_ON, (LocalDateTime)invoiceIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EInvoiceIndexField.SORT_INVOICE__UPDATED_ON, (LocalDateTime)invoiceIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    static String removeInvoicePrefix(@NonNull String invoiceNumber) {
        if (invoiceNumber == null) {
            throw new NullPointerException("invoiceNumber is marked non-null but is null");
        }
        int firstIndex = StringUtils.indexOfAny((CharSequence)invoiceNumber, (String)"0123456789");
        return StringUtils.substring((String)invoiceNumber, (int)firstIndex);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull InvoiceIndexEntry invoiceIndexEntry) {
        if (invoiceIndexEntry == null) {
            throw new NullPointerException("invoiceIndexEntry is marked non-null but is null");
        }
        return InvoiceSearchMapper.documentId((EIndexEntryType)invoiceIndexEntry.getIndexEntryType(), (Long)invoiceIndexEntry.getId());
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(EIndexEntryType indexEntryType, @NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        EInvoiceIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public InvoiceSearchMapper(InvoiceIndexEntrySerializer invoiceIndexEntrySerializer, ConfigService configService) {
        this.invoiceIndexEntrySerializer = invoiceIndexEntrySerializer;
        this.configService = configService;
    }
}

