/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.invoice.InvoicePositionCommon;
import de.qfm.erp.common.response.invoice.InvoicePositionsCommon;
import de.qfm.erp.service.model.jpa.invoice.EInvoicePositionType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class InvoicePositionMapper {
    @Nonnull
    public InvoicePositionCommon map(@NonNull InvoicePosition invoicePosition) {
        if (invoicePosition == null) {
            throw new NullPointerException("invoicePosition is marked non-null but is null");
        }
        InvoicePositionCommon common = new InvoicePositionCommon();
        common.setId(invoicePosition.getId());
        common.setSequenceNumber((Integer)MoreObjects.firstNonNull((Object)invoicePosition.getSequenceNumber(), (Object)0));
        Invoice invoice = invoicePosition.getInvoice();
        common.setInvoiceId(invoice.getId());
        EInvoicePositionType invoicePositionType = (EInvoicePositionType)MoreObjects.firstNonNull((Object)invoicePosition.getInvoicePositionType(), (Object)EInvoicePositionType.UNKNOWN);
        common.setInvoicePositionType(invoicePositionType.name());
        if (invoicePositionType == EInvoicePositionType.MEASUREMENT_POSITION) {
            MeasurementPosition measurementPosition = invoicePosition.getMeasurementPosition();
            if (null != measurementPosition) {
                Measurement measurement = measurementPosition.getMeasurement();
                if (null != measurement) {
                    common.setMeasurementId(measurement.getId());
                    common.setMeasurementNumber(measurement.getMeasurementNumber());
                }
                common.setMeasurementPositionId(measurementPosition.getId());
                common.setAmount(measurementPosition.getAmount());
                common.setFactor1(measurementPosition.getFactor1());
                common.setFactor2(measurementPosition.getFactor2());
                common.setFactor3(measurementPosition.getFactor3());
                common.setRemarks(measurementPosition.getRemarks());
                common.setSurrogatePositionNumber(measurementPosition.getSurrogatePositionNumber());
                common.setUnit(measurementPosition.getUnit());
                common.setShortText(measurementPosition.getShortText());
                common.setFlagFeePosition(measurementPosition.getFlagFeePosition());
                common.setMaterialPurchasePricePerUnit(measurementPosition.getMaterialPurchasePriceIncludingDiscountPerUnit());
                common.setMaterialPurchasePriceAgg(measurementPosition.getMaterialPurchasePriceIncludingDiscountAggregated());
                common.setMaterialSellingPricePerUnit(measurementPosition.getMaterialSellingPricePerUnit());
                common.setMaterialSellingPriceAggregated(measurementPosition.getMaterialSellingPriceAggregated());
                common.setMaterialFactor(measurementPosition.getMaterialPercentage());
                common.setPricePerUnit(measurementPosition.getPricePerUnit());
                common.setPriceAggregated(measurementPosition.getPriceAggregated());
                common.setAddendumNumber(invoicePosition.getAddendumNumber());
                common.setDiscount(invoicePosition.getDiscount());
                common.setDiscountValueAggregated(invoicePosition.getDiscountValueAggregated());
                common.setPriceAggregatedWithDiscount(invoicePosition.getPriceAggregatedWithDiscount());
            }
        } else if (invoicePositionType == EInvoicePositionType.CUSTOM) {
            common.setSurrogatePositionNumber(invoicePosition.getPositionNumber());
            common.setAmount(invoicePosition.getAmount());
            common.setFactor1(invoicePosition.getFactor1());
            common.setFactor2(invoicePosition.getFactor2());
            common.setFactor3(invoicePosition.getFactor3());
            common.setProduct(invoicePosition.getProduct());
            common.setRemarks(invoicePosition.getRemarks());
            common.setUnit(invoicePosition.getUnit());
            common.setShortText(invoicePosition.getShortText());
            common.setFlagFeePosition(invoicePosition.getFlagFeePosition());
            common.setMaterialPurchasePricePerUnit(invoicePosition.getMaterialPurchasePricePerUnit());
            common.setMaterialPurchasePriceAgg(invoicePosition.getMaterialPurchasePriceAgg());
            common.setMaterialSellingPricePerUnit(invoicePosition.getMaterialSellingPricePerUnit());
            common.setMaterialSellingPriceAggregated(invoicePosition.getMaterialSellingPriceAggregated());
            common.setMaterialFactor(invoicePosition.getMaterialFactor());
            common.setPricePerUnit(invoicePosition.getPricePerUnit());
            common.setPriceAggregated(invoicePosition.getPriceAggregated());
            common.setAddendumNumber(invoicePosition.getAddendumNumber());
            common.setDiscount(invoicePosition.getDiscount());
            common.setDiscountValueAggregated(invoicePosition.getDiscountValueAggregated());
            common.setPriceAggregatedWithDiscount(invoicePosition.getPriceAggregatedWithDiscount());
        }
        return common;
    }

    @Nonnull
    public InvoicePositionsCommon map(@NonNull Iterable<InvoicePosition> invoicePositions) {
        if (invoicePositions == null) {
            throw new NullPointerException("invoicePositions is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)Streams.stream(invoicePositions).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new InvoicePositionsCommon(commons.size(), (List)commons);
    }
}

