/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.filestore.FileStoreCommon;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.security.UserService;
import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.rowset.serial.SerialBlob;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileStoreMapper {
    private static final Logger log = LogManager.getLogger(FileStoreMapper.class);
    private final UserService userService;
    private final UserMapper userMapper;

    @Nonnull
    public FileStore merge(@NonNull FileStore entity, @NonNull MultipartFile multiPartFile) throws IOException {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        entity.setUploadName(multiPartFile.getName());
        entity.setUploadOriginalFilename(multiPartFile.getOriginalFilename());
        entity.setUploadSize(multiPartFile.getSize());
        entity.setUploadContentType(multiPartFile.getContentType());
        try {
            SerialBlob b = new SerialBlob(multiPartFile.getBytes());
            entity.setData((Blob)b);
        }
        catch (SQLException e) {
            log.error("Error saving Blob: {}", (Object)e.getMessage(), (Object)e);
        }
        User user = this.userService.authenticatedUser();
        entity.setCreatedByUser(user);
        return entity;
    }

    @Nonnull
    public FileStore merge(@NonNull FileStore entity, @NonNull String name, @NonNull String originalName, @NonNull String contentType, byte[] buffer) throws IOException {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (originalName == null) {
            throw new NullPointerException("originalName is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        entity.setUploadName(name);
        entity.setUploadOriginalFilename(name);
        entity.setUploadSize((long)buffer.length);
        entity.setUploadContentType(contentType);
        try {
            SerialBlob b = new SerialBlob(buffer);
            entity.setData((Blob)b);
        }
        catch (SQLException e) {
            log.error("Error saving Blob: {}", (Object)e.getMessage(), (Object)e);
        }
        User user = this.userService.authenticatedUser();
        entity.setCreatedByUser(user);
        return entity;
    }

    @Nonnull
    public FileStoreCommon map(@NonNull FileStore entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        FileStoreCommon common = new FileStoreCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setUuid(entity.getUuid());
        common.setUploadName(entity.getUploadName());
        common.setUploadContentType(entity.getUploadContentType());
        common.setUploadOriginalFilename(entity.getUploadOriginalFilename());
        common.setUploadSize(Long.valueOf(entity.getUploadSize()));
        User createdByUser = entity.getCreatedByUser();
        if (null != createdByUser) {
            UserCommon createdByUserCommon = this.userMapper.mapUser(createdByUser);
            common.setCreatedByUser(createdByUserCommon);
        }
        return common;
    }

    public FileStoreMapper(UserService userService, UserMapper userMapper) {
        this.userService = userService;
        this.userMapper = userMapper;
    }
}

