/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.entityusage.EntityUsageCommon;
import de.qfm.erp.common.response.entityusage.EntityUsagePageCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.navigation.EEntityUsageType;
import de.qfm.erp.service.model.jpa.navigation.EntityUsage;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class EntityUsageMapper {
    @Nonnull
    public EntityUsageCommon map(@NonNull EntityUsage item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        EntityUsageCommon common = new EntityUsageCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setEntityId(item.getEntityId());
        User user = item.getUser();
        if (null != user) {
            common.setUserId(user.getId());
        }
        EEntityClass entityClass = (EEntityClass)MoreObjects.firstNonNull((Object)item.getEntityClass(), (Object)EEntityClass.NONE);
        common.setEntityClass(entityClass.name());
        EEntityUsageType entityUsageType = (EEntityUsageType)MoreObjects.firstNonNull((Object)item.getEntityUsageType(), (Object)EEntityUsageType.UNKNOWN);
        common.setEntityUsageType(entityUsageType.name());
        return common;
    }

    @Nonnull
    public EntityUsagePageCommon map(@NonNull Page<EntityUsage> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (EntityUsagePageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new EntityUsagePageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }
}

