/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.search.EEntityIndexField;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EntityIndexEntry;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.service.mapper.search.EntityIndexEntrySerializer;
import de.qfm.erp.service.service.service.ConfigService;
import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EntitySearchMapper {
    private static final Logger log = LogManager.getLogger(EntitySearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private final EntityIndexEntrySerializer entityIndexEntrySerializer;
    private final ConfigService configService;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull QEntity item, @NonNull EIndexEntryType indexEntryType) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(item, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<QEntity> items, @NonNull EIndexEntryType indexEntryType) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public EntityIndexEntry mapToIndexEntry(@NonNull QEntity item, @NonNull EIndexEntryType indexEntryType) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        EntityIndexEntry indexEntry = new EntityIndexEntry();
        indexEntry.setId(item.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(item.getCreatedOn());
        indexEntry.setCreatedBy(item.getCreatedBy());
        indexEntry.setUpdatedOn(item.getUpdatedOn());
        indexEntry.setUpdatedBy(item.getUpdatedBy());
        indexEntry.setEntityState(item.getEntityState());
        indexEntry.setQEntityState(item.getQEntityState());
        indexEntry.setEntityNumber(item.getQNumber());
        indexEntry.setEntityAlias(item.getAlias());
        Quotation primaryStage = item.getPrimaryStage();
        if (null != primaryStage) {
            indexEntry.setPrimaryStageId(primaryStage.getId().longValue());
            indexEntry.setPrimaryStageNumber(primaryStage.getQNumber());
            indexEntry.setPrimaryStageType(primaryStage.getStageType());
            indexEntry.setPrimaryStageState(primaryStage.getStageState());
        }
        return indexEntry;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull EntityIndexEntry indexEntry) {
        String source;
        Document document = new Document();
        String documentId = EntitySearchMapper.documentId((EntityIndexEntry)indexEntry);
        String type = indexEntry.getIndexEntryType().name();
        try {
            source = this.entityIndexEntrySerializer.serialize(indexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)EEntityIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)EEntityIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EEntityIndexField.ENTITY__CREATED_ON, (LocalDateTime)indexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EEntityIndexField.ENTITY__UPDATED_ON, (LocalDateTime)indexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__CREATED_BY, (String)indexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__UPDATED_BY, (String)indexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        EQEntityState entityState = (EQEntityState)MoreObjects.firstNonNull((Object)indexEntry.getQEntityState(), (Object)EQEntityState.UNKNOWN);
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__QENTITY_STATE, (String)entityState.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__ENTITY_NUMBER, (String)StringUtils.removeStart((String)indexEntry.getEntityNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__ENTITY_NUMBER, (String)indexEntry.getEntityNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__PRIMARY_STAGE_NUMBER, (String)StringUtils.removeStart((String)indexEntry.getPrimaryStageNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__PRIMARY_STAGE_NUMBER, (String)indexEntry.getPrimaryStageNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EEntityIndexField.ENTITY__ENTITY_ALIAS, (String)indexEntry.getEntityAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EEntityIndexField.ENTITY__PRIMARY_STAGE_ALIAS, (String)indexEntry.getPrimaryStageAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EEntityIndexField.ENTITY__CUSTOMER__NAME, (String)indexEntry.getCustomerName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__PRIMARY_STAGE_QUOTATION_NUMBER, (String)StringUtils.remove((String)indexEntry.getPrimaryStageQuotationNumber(), (String)"/")).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EEntityIndexField.ENTITY__PRIMARY_STAGE_QUOTATION_NUMBER, (String)indexEntry.getPrimaryStageQuotationNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        String allFromDocument = EntitySearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)EEntityIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull EntityIndexEntry indexEntry) {
        if (indexEntry == null) {
            throw new NullPointerException("indexEntry is marked non-null but is null");
        }
        return EntitySearchMapper.documentId((EIndexEntryType)indexEntry.getIndexEntryType(), (Long)indexEntry.getId());
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull EIndexEntryType indexEntryType, @NonNull Long id) {
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        EEntityIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public EntitySearchMapper(EntityIndexEntrySerializer entityIndexEntrySerializer, ConfigService configService) {
        this.entityIndexEntrySerializer = entityIndexEntrySerializer;
        this.configService = configService;
    }
}

