/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.generic.DictionaryItemUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.generic.DictionaryItemCommon;
import de.qfm.erp.common.response.generic.DictionaryItemPageCommon;
import de.qfm.erp.common.response.generic.DictionarySubItemCommon;
import de.qfm.erp.common.response.generic.DictionarySubItemListCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.generic.DictionaryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class DictionaryItemMapper {
    @Nonnull
    public DictionaryItemCommon map(@NonNull DictionaryItem item, @NonNull BiFunction<EEntityClass, Long, String> fn) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        DictionaryItemCommon common = new DictionaryItemCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        Long entityId = item.getEntityId();
        EEntityClass safeEntityClazz = (EEntityClass)MoreObjects.firstNonNull((Object)item.getEntityClass(), (Object)EEntityClass.NONE);
        String entityClazzName = safeEntityClazz.name();
        String entityName = fn.apply(safeEntityClazz, entityId);
        common.setEntityId(entityId);
        common.setEntityClass(entityClazzName);
        common.setEntityName(entityName);
        common.setName(item.getName());
        common.setDescription(item.getDescription());
        common.setSequentialNumber(item.getSequentialNumber());
        common.setFlagHidden(item.getFlagHidden());
        return common;
    }

    @Nonnull
    public DictionaryItemPageCommon map(@NonNull Page<DictionaryItem> page, @NonNull BiFunction<EEntityClass, Long, String> fn) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return (DictionaryItemPageCommon)BaseMapper.map(page, item -> this.map(item, fn), (pageNumber, pageSize, totalElements, totalPages, items) -> new DictionaryItemPageCommon(pageNumber, pageSize, totalPages, totalElements, items), (l, r) -> StringUtils.compare((String)l.getName(), (String)r.getName()));
    }

    @Nonnull
    public DictionaryItem merge(@NonNull DictionaryItem dictionaryItem, @NonNull EEntityClass entityClass, @NonNull DictionaryItemUpdateRequest updateRequest) {
        if (dictionaryItem == null) {
            throw new NullPointerException("dictionaryItem is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        dictionaryItem.setEntityId(updateRequest.getEntityId());
        dictionaryItem.setEntityClass(entityClass);
        dictionaryItem.setName(StringUtils.trimToEmpty((String)updateRequest.getName()));
        dictionaryItem.setDescription(StringUtils.trimToEmpty((String)updateRequest.getDescription()));
        dictionaryItem.setSequentialNumber(updateRequest.getSequentialNumber());
        dictionaryItem.setFlagHidden(updateRequest.getFlagHidden());
        return dictionaryItem;
    }

    @Nonnull
    public DictionarySubItemListCommon map(@NonNull List<Pair<Long, String>> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        ImmutableList subItemCommons = (ImmutableList)values.stream().map((? super T item) -> DictionarySubItemCommon.of((Long)((Long)item.getLeft()), (String)((String)item.getRight()))).collect(ImmutableList.toImmutableList());
        return new DictionarySubItemListCommon(subItemCommons.size(), (List)subItemCommons);
    }
}

