/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.CustomerHelper;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.model.jpa.customer.ECustomerType;
import de.qfm.erp.service.model.search.CustomerIndexEntry;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.service.mapper.search.CustomerIndexEntrySerializer;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CustomerSearchMapper {
    private static final Logger log = LogManager.getLogger(CustomerSearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private static final Splitter NAME_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"-,")).trimResults();
    private final CustomerIndexEntrySerializer customerIndexEntrySerializer;
    private final Analyzer indexAnalyzer;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull Customer customer, @NonNull EIndexEntryType indexEntryType) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(customer, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<Customer> customers, @NonNull EIndexEntryType indexEntryType) {
        if (customers == null) {
            throw new NullPointerException("customers is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(customers).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public CustomerIndexEntry mapToIndexEntry(@NonNull Customer customer, @NonNull EIndexEntryType indexEntryType) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        CustomerIndexEntry indexEntry = new CustomerIndexEntry();
        indexEntry.setId(customer.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(customer.getCreatedOn());
        indexEntry.setCreatedBy(customer.getCreatedBy());
        indexEntry.setUpdatedOn(customer.getUpdatedOn());
        indexEntry.setUpdatedBy(customer.getUpdatedBy());
        indexEntry.setName(customer.getName());
        indexEntry.setDebtorAccountNumber(customer.getDebtorAccountNumber());
        indexEntry.setEntityState(customer.getEntityState());
        ECustomerState customerState = (ECustomerState)MoreObjects.firstNonNull((Object)customer.getCustomerState(), (Object)ECustomerState.UNKNOWN);
        indexEntry.setCustomerState(customerState);
        ECustomerType customerType = (ECustomerType)MoreObjects.firstNonNull((Object)customer.getCustomerType(), (Object)ECustomerType.UNKNOWN);
        indexEntry.setCustomerType(customerType);
        LinkedHashSet addresses = Sets.newLinkedHashSet();
        for (Address address : customer.getAddresses()) {
            String addressTxt = CustomerHelper.addressText((Address)address);
            if (!StringUtils.isNotBlank((CharSequence)addressTxt)) continue;
            addresses.add(addressTxt);
        }
        indexEntry.setAddresses((List)ImmutableList.copyOf((Collection)addresses));
        return indexEntry;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull CustomerIndexEntry customerIndexEntry) {
        String source;
        Document document = new Document();
        String documentId = CustomerSearchMapper.documentId((CustomerIndexEntry)customerIndexEntry);
        String type = customerIndexEntry.getIndexEntryType().name();
        try {
            source = this.customerIndexEntrySerializer.serialize(customerIndexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)ECustomerIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.numeric((IndexField)ECustomerIndexField.CUSTOMER__ID, (Long)customerIndexEntry.getId()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)ECustomerIndexField.CUSTOMER__CREATED_ON, (LocalDateTime)customerIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)ECustomerIndexField.CUSTOMER__UPDATED_ON, (LocalDateTime)customerIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__CREATED_BY, (String)customerIndexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__UPDATED_BY, (String)customerIndexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        EntityState entityState = (EntityState)MoreObjects.firstNonNull((Object)customerIndexEntry.getEntityState(), (Object)EntityState.INVALID);
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__ENTITY_STATE, (String)entityState.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        ECustomerState customerState = (ECustomerState)MoreObjects.firstNonNull((Object)customerIndexEntry.getCustomerState(), (Object)ECustomerState.UNKNOWN);
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__CUSTOMER_STATE, (String)customerState.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        ECustomerType customerType = (ECustomerType)MoreObjects.firstNonNull((Object)customerIndexEntry.getCustomerType(), (Object)ECustomerType.UNKNOWN);
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__CUSTOMER_TYPE, (String)customerType.name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)ECustomerIndexField.CUSTOMER__NAME, (String)customerIndexEntry.getName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__DEBTOR_ACCOUNT_NUMBER, (String)customerIndexEntry.getDebtorAccountNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        List customerAddresses = (List)MoreObjects.firstNonNull((Object)customerIndexEntry.getAddresses(), (Object)ImmutableList.of());
        customerAddresses.forEach(item -> LuceneHelper.notTokenized((IndexField)ECustomerIndexField.CUSTOMER__ADDRESS, (String)item).ifPresent(arg_0 -> ((Document)document).add(arg_0)));
        String allFromDocument = CustomerSearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)ECustomerIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)ECustomerIndexField.SORT_CUSTOMER__CREATED_ON, (LocalDateTime)customerIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)ECustomerIndexField.SORT_CUSTOMER__UPDATED_ON, (LocalDateTime)customerIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull CustomerIndexEntry customerIndexEntry) {
        if (customerIndexEntry == null) {
            throw new NullPointerException("customerIndexEntry is marked non-null but is null");
        }
        return CustomerSearchMapper.documentId((EIndexEntryType)customerIndexEntry.getIndexEntryType(), (Long)customerIndexEntry.getId());
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull EIndexEntryType indexEntryType, @NonNull Long id) {
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        ECustomerIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public CustomerSearchMapper(CustomerIndexEntrySerializer customerIndexEntrySerializer, Analyzer indexAnalyzer) {
        this.customerIndexEntrySerializer = customerIndexEntrySerializer;
        this.indexAnalyzer = indexAnalyzer;
    }
}

