/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.businessunit.BusinessUnitCommon;
import de.qfm.erp.common.response.businessunit.BusinessUnitUserCommon;
import de.qfm.erp.common.response.businessunit.BusinessUnitsResponse;
import de.qfm.erp.common.response.businessunit.BusinessUnitsTreeResponse;
import de.qfm.erp.service.model.internal.businessunit.BusinessUnitTree;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BusinessUnitMapper {
    @Nonnull
    public BusinessUnitCommon mapToCommon(@NonNull BusinessUnit businessUnit) {
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        BusinessUnitCommon common = (BusinessUnitCommon)BaseMapper.map((EntityBase)businessUnit, (EntityBaseCommon)new BusinessUnitCommon());
        return this.mapInto(businessUnit, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), common);
    }

    @Nonnull
    public BusinessUnitCommon mapToCommon(@NonNull BusinessUnit businessUnit, @NonNull Iterable<User> managers, @NonNull Iterable<User> employees) {
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        if (managers == null) {
            throw new NullPointerException("managers is marked non-null but is null");
        }
        if (employees == null) {
            throw new NullPointerException("employees is marked non-null but is null");
        }
        BusinessUnitCommon common = (BusinessUnitCommon)BaseMapper.map((EntityBase)businessUnit, (EntityBaseCommon)new BusinessUnitCommon());
        return this.mapInto(businessUnit, managers, employees, common);
    }

    @Nonnull
    public BusinessUnitsResponse mapToResponse(@NonNull Iterable<BusinessUnit> businessUnits) {
        if (businessUnits == null) {
            throw new NullPointerException("businessUnits is marked non-null but is null");
        }
        int size = Iterables.size(businessUnits);
        List itemsCommon = (List)IterableHelper.stream(businessUnits).map(arg_0 -> this.mapToCommon(arg_0)).collect(ImmutableList.toImmutableList());
        return new BusinessUnitsResponse(size, itemsCommon);
    }

    @Nonnull
    private <T extends BusinessUnitCommon> T mapInto(@NonNull BusinessUnit businessUnit, @NonNull Iterable<User> managers, @NonNull Iterable<User> employees, @NonNull T common) {
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        if (managers == null) {
            throw new NullPointerException("managers is marked non-null but is null");
        }
        if (employees == null) {
            throw new NullPointerException("employees is marked non-null but is null");
        }
        if (common == null) {
            throw new NullPointerException("common is marked non-null but is null");
        }
        common.setId(businessUnit.getId());
        BusinessUnitMapper.applyString(() -> ((BusinessUnit)businessUnit).getShortName(), arg_0 -> common.setShortName(arg_0));
        BusinessUnitMapper.applyString(() -> ((BusinessUnit)businessUnit).getLongName(), arg_0 -> common.setLongName(arg_0));
        BusinessUnitMapper.applyString(() -> ((BusinessUnit)businessUnit).getCostCenter(), arg_0 -> common.setCostCenter(arg_0));
        Long parentId = null != businessUnit.getParent() ? businessUnit.getParent().getId() : null;
        common.setParentId(parentId);
        Iterable managersCommon = (Iterable)IterableHelper.stream(managers).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        Iterable employeesCommon = (Iterable)IterableHelper.stream(employees).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        common.setManagers(managersCommon);
        common.setEmployees(employeesCommon);
        return common;
    }

    @Nonnull
    private BusinessUnitUserCommon map(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        BusinessUnitUserCommon common = new BusinessUnitUserCommon();
        common.setId(user.getId());
        common.setFirstName(user.getFirstName());
        common.setLastName(user.getLastName());
        common.setFullName(user.getFullName());
        return common;
    }

    @Nonnull
    public BusinessUnitsTreeResponse mapToResponse(@NonNull BusinessUnitTree businessUnitTree) {
        if (businessUnitTree == null) {
            throw new NullPointerException("businessUnitTree is marked non-null but is null");
        }
        int level = businessUnitTree.getLevel();
        BusinessUnit current = businessUnitTree.getBusinessUnit();
        List users = businessUnitTree.getUsers();
        Iterable managers = (Iterable)IterableHelper.stream((Iterable)users).filter(item -> Objects.equals(Boolean.TRUE, item.getRight())).map(Pair::getLeft).collect(ImmutableList.toImmutableList());
        Iterable employees = (Iterable)IterableHelper.stream((Iterable)users).filter(item -> Objects.equals(Boolean.FALSE, item.getRight())).map(Pair::getLeft).collect(ImmutableList.toImmutableList());
        List children = businessUnitTree.getChildren();
        int childrenAmount = children.size();
        BusinessUnitCommon businessUnitCommon = this.mapToCommon(current, managers, employees);
        List childrenCommon = (List)children.stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(ImmutableList.toImmutableList());
        return new BusinessUnitsTreeResponse(childrenAmount, childrenCommon, level, businessUnitCommon);
    }

    @Nonnull
    public static String applyString(@NonNull Supplier<String> s, @NonNull Consumer<String> c) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        String safe = StringUtils.trimToEmpty((String)s.get());
        c.accept(safe);
        return safe;
    }
}

