/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.InvoiceRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DirtyInvoiceStoreRefreshJob {
    private static final Logger log = LogManager.getLogger(DirtyInvoiceStoreRefreshJob.class);
    private final InvoiceRoute route;

    @Scheduled(initialDelayString="${scheduler.store.exporter.dirty.processing.ms}", fixedDelayString="${scheduler.store.exporter.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean trigger() {
        log.debug("Triggering Dirty Invoice Store Refresh");
        return this.route.pushToStore();
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Invoice Store Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public DirtyInvoiceStoreRefreshJob(InvoiceRoute route) {
        this.route = route;
    }
}

