/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler.impl;

import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.internal.eventbus.UserChangeMessage;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.queue.QueueItem;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.QueueItemRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.InternalAuthPersistenceHelper;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.QueueService;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class QueueHandlerImpl
extends BaseHandler<QueueItem>
implements QueueService,
ApplicationListener<UserChangeMessage> {
    private static final Logger log = LogManager.getLogger(QueueHandlerImpl.class);
    private final ApplicationConfig applicationConfig;
    private final EntityFactory entityFactory;
    private final QueueItemRepository repository;

    @Autowired
    public QueueHandlerImpl(ApplicationConfig applicationConfig, InternalAuthPersistenceHelper persistenceHelper, EntityFactory entityFactory, QueueItemRepository repository) {
        super((PersistenceHelper)persistenceHelper, (JpaRepository)repository);
        this.applicationConfig = applicationConfig;
        this.entityFactory = entityFactory;
        this.repository = repository;
    }

    protected Class<QueueItem> clazz() {
        return QueueItem.class;
    }

    @Nonnull
    protected QueueItem beforeUpdate(@NonNull QueueItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QueueItem beforeDelete(@NonNull QueueItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QueueItem afterUpdate(@NonNull QueueItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QueueItem afterDelete(@NonNull QueueItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public QueueItem append(@NonNull EQueueItemType queueItemType, @NonNull EReferenceType referenceType, @NonNull Long referenceId) {
        if (queueItemType == null) {
            throw new NullPointerException("queueItemType is marked non-null but is null");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        QueueItem queueItem = this.entityFactory.queueItem();
        queueItem.setQueueItemType(queueItemType);
        queueItem.setReferenceType(referenceType);
        queueItem.setReferenceId(referenceId);
        queueItem.setFailureAmount(Integer.valueOf(0));
        return (QueueItem)this.repository.save((Object)((QueueItem)this.baseUpdate((EntityBase)queueItem)));
    }

    @Nonnull
    public QueueItem put(@NonNull EQueueItemType queueItemType, @NonNull EReferenceType referenceType, @NonNull Long referenceId) {
        if (queueItemType == null) {
            throw new NullPointerException("queueItemType is marked non-null but is null");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional queueItemOptional = this.repository.findByReferenceTypeAndReferenceId(referenceType, referenceId);
        QueueItem queueItem = queueItemOptional.orElseGet(() -> ((EntityFactory)this.entityFactory).queueItem());
        queueItem.setQueueItemType(queueItemType);
        queueItem.setReferenceType(referenceType);
        queueItem.setReferenceId(referenceId);
        queueItem.setFailureAmount(Integer.valueOf(0));
        return (QueueItem)this.repository.save((Object)((QueueItem)this.baseUpdate((EntityBase)queueItem)));
    }

    @Nonnull
    public Iterable<QueueItem> pull(int limit) {
        int maxTries = this.applicationConfig.getQueueProcessingMaxTries();
        return this.repository.pull((Pageable)PageRequest.of((int)0, (int)limit), maxTries);
    }

    public void processed(@NonNull QueueItem queueItem) {
        if (queueItem == null) {
            throw new NullPointerException("queueItem is marked non-null but is null");
        }
        this.repository.delete((Object)queueItem);
    }

    public void processed(@NonNull Iterable<QueueItem> queueItems) {
        if (queueItems == null) {
            throw new NullPointerException("queueItems is marked non-null but is null");
        }
        this.repository.deleteAll(queueItems);
    }

    public void failure(@NonNull QueueItem queueItem) {
        if (queueItem == null) {
            throw new NullPointerException("queueItem is marked non-null but is null");
        }
        int currentFailureAmount = queueItem.getFailureAmount();
        queueItem.setFailureAmount(Integer.valueOf(currentFailureAmount + 1));
        this.repository.save((Object)queueItem);
    }

    public void onApplicationEvent(@NonNull UserChangeMessage userChangeMessage) {
        if (userChangeMessage == null) {
            throw new NullPointerException("userChangeMessage is marked non-null but is null");
        }
        this.updated(EReferenceType.USER, ((User)userChangeMessage.getEntity()).getId());
    }
}

