/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler.impl;

import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.search.NodeOffset;
import de.qfm.erp.service.repository.NodeOffsetRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.InternalAuthPersistenceHelper;
import de.qfm.erp.service.service.handler.NodeOffsetHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Component;

@Component
public class NodeOffsetHandlerImpl
extends BaseHandler<NodeOffset>
implements NodeOffsetHandler {
    private static final Logger log = LogManager.getLogger(NodeOffsetHandlerImpl.class);
    private final NodeConfig nodeConfig;
    private final EntityFactory entityFactory;
    private final NodeOffsetRepository repository;

    @Autowired
    public NodeOffsetHandlerImpl(InternalAuthPersistenceHelper persistenceHelper, NodeOffsetRepository repository, NodeConfig nodeConfig, EntityFactory entityFactory) {
        super((PersistenceHelper)persistenceHelper, (JpaRepository)repository);
        this.nodeConfig = nodeConfig;
        this.entityFactory = entityFactory;
        this.repository = repository;
    }

    @Nonnull
    protected Class<NodeOffset> clazz() {
        return NodeOffset.class;
    }

    @Nonnull
    protected NodeOffset beforeUpdate(@NonNull NodeOffset item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected NodeOffset beforeDelete(@NonNull NodeOffset item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected NodeOffset afterUpdate(@NonNull NodeOffset item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected NodeOffset afterDelete(@NonNull NodeOffset item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public NodeOffset getByEntityType(@NonNull EEntityClass entityClazz) {
        if (entityClazz == null) {
            throw new NullPointerException("entityClazz is marked non-null but is null");
        }
        String nodeName = this.nodeConfig.getNodeName();
        return this.repository.findFirstByEntityClazzAndNodeName(entityClazz, nodeName).orElse(this.entityFactory.nodeOffset(entityClazz, nodeName, MIN_DATE));
    }

    @Nonnull
    public NodeOffset putByEntityType(@NonNull EEntityClass entityClazz, @NonNull LocalDateTime referenceDateTime) {
        NodeOffset nodeOffset;
        if (entityClazz == null) {
            throw new NullPointerException("entityClazz is marked non-null but is null");
        }
        if (referenceDateTime == null) {
            throw new NullPointerException("referenceDateTime is marked non-null but is null");
        }
        String nodeName = this.nodeConfig.getNodeName();
        Optional nodeOffsetCandidate = this.repository.findFirstByEntityClazzAndNodeName(entityClazz, nodeName);
        if (nodeOffsetCandidate.isPresent()) {
            nodeOffset = (NodeOffset)nodeOffsetCandidate.get();
            nodeOffset.setReferenceDateTime(referenceDateTime);
        } else {
            nodeOffset = this.entityFactory.nodeOffset(entityClazz, nodeName, referenceDateTime);
        }
        return (NodeOffset)this.update((EntityBase)nodeOffset);
    }
}

