/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.ReleaseOrderRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class ReleaseOrderHandler
extends BaseHandler<ReleaseOrder> {
    private final ReleaseOrderRepository releaseOrderRepository;

    @Autowired
    public ReleaseOrderHandler(StandardPersistenceHelper standardPersistenceHelper, ReleaseOrderRepository releaseOrderRepository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)releaseOrderRepository);
        this.releaseOrderRepository = releaseOrderRepository;
    }

    protected Class<ReleaseOrder> clazz() {
        return ReleaseOrder.class;
    }

    @Nonnull
    protected ReleaseOrder beforeUpdate(@NonNull ReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected ReleaseOrder beforeDelete(@NonNull ReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected ReleaseOrder afterUpdate(@NonNull ReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected ReleaseOrder afterDelete(@NonNull ReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<ReleaseOrder> list(int page, int size) {
        return this.releaseOrderRepository.findAll((Pageable)PageRequest.of((int)page, (int)size));
    }

    @Nonnull
    public Page<ReleaseOrder> listByQuotationAndSquad(@NonNull Quotation quotation, @NonNull User user, int page, int size) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.releaseOrderRepository.listByQuotationAndSquad((Pageable)PageRequest.of((int)page, (int)size), quotation, user);
    }

    @Nonnull
    public Page<ReleaseOrder> listBySquad(@NonNull User user, int page, int size) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.releaseOrderRepository.listBySquad((Pageable)PageRequest.of((int)page, (int)size), user);
    }

    @Nonnull
    public Page<ReleaseOrder> listByQuotation(@NonNull Quotation quotation, int page, int size) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this.releaseOrderRepository.listByQuotation((Pageable)PageRequest.of((int)page, (int)size), quotation);
    }

    @Nonnull
    public Optional<ReleaseOrder> byReferenceIdNotFailing(String referenceId) {
        return this.releaseOrderRepository.findByReferenceId(referenceId);
    }

    @Nonnull
    public ReleaseOrder byReferenceIdFailing(@Nonnull String referenceId) {
        Optional byId = this.byReferenceIdNotFailing(referenceId);
        if (byId.isEmpty()) {
            throw ResourceNotFoundException.of((String)ReleaseOrder.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (String)referenceId);
        }
        return (ReleaseOrder)byId.get();
    }

    @Nonnull
    public Iterable<ReleaseOrder> allByPssReleaseOrderAndName(@NonNull PssReleaseOrder pssReleaseOrder) {
        if (pssReleaseOrder == null) {
            throw new NullPointerException("pssReleaseOrder is marked non-null but is null");
        }
        return this.releaseOrderRepository.findAllByPssReleaseOrder(pssReleaseOrder);
    }
}

