/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.queue.QueueItem;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;

public interface QueueService {
    @Nonnull
    default public QueueItem updated(@NonNull EReferenceType referenceType, @NonNull Long referenceId) {
        if (referenceType == null) {
            throw new NullPointerException("referenceType is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.put(EQueueItemType.UPDATED, referenceType, referenceId);
    }

    @Nonnull
    default public QueueItem deleted(@NonNull EReferenceType referenceType, @NonNull Long referenceId) {
        if (referenceType == null) {
            throw new NullPointerException("referenceType is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.put(EQueueItemType.DELETED, referenceType, referenceId);
    }

    @Nonnull
    public QueueItem append(@NonNull EQueueItemType var1, @NonNull EReferenceType var2, @NonNull Long var3);

    @Nonnull
    public QueueItem put(@NonNull EQueueItemType var1, @NonNull EReferenceType var2, @NonNull Long var3);

    @Nonnull
    default public Optional<QueueItem> pull() {
        Iterable queueItems = this.pull(1);
        if (Iterables.size((Iterable)queueItems) == 1) {
            return Optional.of((QueueItem)Iterables.get((Iterable)queueItems, (int)0));
        }
        return Optional.empty();
    }

    @Nonnull
    public Iterable<QueueItem> pull(int var1);

    public void processed(@NonNull QueueItem var1);

    public void processed(@NonNull Iterable<QueueItem> var1);

    public void failure(@NonNull QueueItem var1);
}

