/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.repository.ProjectRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class ProjectHandler
extends BaseHandler<Project> {
    private static final Logger log = LogManager.getLogger(ProjectHandler.class);
    private final ProjectRepository repository;

    @Autowired
    public ProjectHandler(StandardPersistenceHelper standardPersistenceHelper, ProjectRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<Project> clazz() {
        return Project.class;
    }

    @Nonnull
    protected Project beforeUpdate(@NonNull Project item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Project afterUpdate(@NonNull Project item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Project afterDelete(@NonNull Project item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Project beforeDelete(@NonNull Project item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<Project> page(@NonNull Pageable pageable, @NonNull String filterText) {
        if (pageable == null) {
            throw new NullPointerException("pageable is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.repository.findAllByNameLikeIgnoreCaseAndEntityStateIn(pageable, "%" + filterText + "%", EntityState.ENTITY_STATES__NOT_DELETED);
    }
}

