/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.invoice.EInvoiceNumberGroup;
import de.qfm.erp.service.model.jpa.invoice.InvoiceNumber;
import de.qfm.erp.service.repository.InvoiceNumberRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class InvoiceNumberHandler
extends BaseHandler<InvoiceNumber> {
    private static final Logger log = LogManager.getLogger(InvoiceNumberHandler.class);
    private final InvoiceNumberRepository repository;

    @Autowired
    public InvoiceNumberHandler(StandardPersistenceHelper standardPersistenceHelper, InvoiceNumberRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<InvoiceNumber> clazz() {
        return InvoiceNumber.class;
    }

    @Nonnull
    protected InvoiceNumber beforeUpdate(@NonNull InvoiceNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected InvoiceNumber afterUpdate(@NonNull InvoiceNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected InvoiceNumber beforeDelete(@NonNull InvoiceNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected InvoiceNumber afterDelete(@NonNull InvoiceNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Optional<InvoiceNumber> byTypeAndYearNotFailing(@NonNull EInvoiceNumberGroup invoiceNumberGroup, @NonNull Integer year) {
        if (invoiceNumberGroup == null) {
            throw new NullPointerException("invoiceNumberGroup is marked non-null but is null");
        }
        if (year == null) {
            throw new NullPointerException("year is marked non-null but is null");
        }
        return this.repository.findByInvoiceNumberGroupAndInvoiceYear(invoiceNumberGroup, year);
    }
}

