/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.internal.measurement.IEntityUsage;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.navigation.EntityUsage;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.EntityUsageRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class EntityUsageHandler
extends BaseHandler<EntityUsage> {
    private static final Logger log = LogManager.getLogger(EntityUsageHandler.class);
    private final EntityUsageRepository repository;

    @Autowired
    public EntityUsageHandler(StandardPersistenceHelper standardPersistenceHelper, EntityUsageRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<EntityUsage> clazz() {
        return EntityUsage.class;
    }

    @Nonnull
    protected EntityUsage beforeUpdate(@NonNull EntityUsage item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected EntityUsage afterUpdate(@NonNull EntityUsage item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected EntityUsage afterDelete(@NonNull EntityUsage item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected EntityUsage beforeDelete(@NonNull EntityUsage item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<EntityUsage> pageByUserAndEntityClass(@NonNull User user, @NonNull EEntityClass entityClass, int page, int size) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        return this.repository.findAllByUserAndEntityClassAndDeletedOnIsNull(user, entityClass, (Pageable)pageRequest);
    }

    @Nonnull
    public Page<IEntityUsage> entityIdsByUserAndEntityClass(@NonNull User user, @NonNull EEntityClass entityClass, @NonNull Pageable pageRequest) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (pageRequest == null) {
            throw new NullPointerException("pageRequest is marked non-null but is null");
        }
        return this.repository.allDistinctEntityIdByUserAndEntityClassAndDeletedOnIsNull(user, entityClass, pageRequest);
    }

    public void clean(@NonNull User user, @NonNull EEntityClass entityClass, @NonNull Long entityId, @NonNull LocalDateTime referenceTTL) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (referenceTTL == null) {
            throw new NullPointerException("referenceTTL is marked non-null but is null");
        }
        long deleted = this.repository.deleteAllByUserAndEntityClassAndEntityIdAndCreatedOnLessThanEqual(user, entityClass, entityId, referenceTTL);
    }
}

