/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.sharepoint.ESharepointState;
import de.qfm.erp.service.model.internal.sharepoint.SharepointSyncMark;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.repository.CustomerRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class CustomerHandler
extends BaseHandler<Customer> {
    private static final Logger log = LogManager.getLogger(CustomerHandler.class);
    private final CustomerRepository repository;

    @Autowired
    public CustomerHandler(StandardPersistenceHelper standardPersistenceHelper, CustomerRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<Customer> clazz() {
        return Customer.class;
    }

    @Nonnull
    protected Customer beforeUpdate(@NonNull Customer item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        if (null == item.getId()) {
            item.setSharepointState(ESharepointState.NOT_SYNCED);
        }
        return item;
    }

    @Nonnull
    protected Customer afterUpdate(@NonNull Customer item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Customer afterDelete(@NonNull Customer item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Customer beforeDelete(@NonNull Customer item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        return item;
    }

    @Nonnull
    public Page<Customer> page(int page, int size, @NonNull String filterText, boolean includeArchived) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        CustomerRepository.CustomerSpec.entityStatesIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableSet customerStates = includeArchived ? ImmutableSet.of((Object)ECustomerState.ACTIVE, (Object)ECustomerState.ARCHIVED, (Object)ECustomerState.TEMPORARY, (Object)ECustomerState.UNKNOWN) : ImmutableSet.of((Object)ECustomerState.ACTIVE, (Object)ECustomerState.TEMPORARY, (Object)ECustomerState.UNKNOWN);
        CustomerRepository.CustomerSpec.customerStatesIn((Iterable)customerStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        CustomerRepository.CustomerSpec.text((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        specsBuilder.add((Object)CustomerRepository.CustomerSpec.identity((boolean)true));
        ImmutableList specs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"shortName")});
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification conjunction = CustomerRepository.CustomerSpec.conjunction((Specification)CustomerRepository.CustomerSpec.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    public boolean dirty() {
        return !this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<Customer> dirtyPage(int max) {
        return this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    public int markIndexed(@NonNull Iterable<Customer> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet invoiceIds = (ImmutableSet)Streams.stream(itemsProcessed).map(Customer::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.repository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)invoiceIds);
    }

    @Nonnull
    public Iterable<Customer> nextUnprocessedSharepoint(int amount) {
        return this.repository.findAllSharepointNotSynced((Iterable)ImmutableSet.of((Object)ESharepointState.NOT_SYNCED), (Pageable)PageRequest.of((int)0, (int)amount, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id"})));
    }

    public int markSharepointSynced(@NonNull SharepointSyncMark sharepointSyncMark) {
        if (sharepointSyncMark == null) {
            throw new NullPointerException("sharepointSyncMark is marked non-null but is null");
        }
        return this.repository.updateSharepointState(ESharepointState.SYNCED, sharepointSyncMark.getSharepointUrl(), sharepointSyncMark.getSharepointSiteId(), sharepointSyncMark.getSharepointDriveId(), sharepointSyncMark.getSharepointDriveItemId(), sharepointSyncMark.getId());
    }

    public void markSharepointSkipped(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        this.repository.updateSharepointState(ESharepointState.SKIPPED, "", "", "", "", customer.getId().longValue());
    }
}

