/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class BaseHandler<T extends EntityBase> {
    protected static final Joiner ID_JOINER = Joiner.on((String)", ").skipNulls();
    protected final PersistenceHelper persistenceHelper;
    protected final JpaRepository<T, Long> repository;

    public BaseHandler(PersistenceHelper persistenceHelper, JpaRepository<T, Long> repository) {
        this.persistenceHelper = persistenceHelper;
        this.repository = repository;
    }

    protected abstract Class<T> clazz();

    @Nonnull
    protected abstract T beforeUpdate(@NonNull T var1);

    @Nonnull
    protected abstract T afterUpdate(@NonNull T var1);

    @Nonnull
    protected abstract T beforeDelete(@NonNull T var1);

    @Nonnull
    protected abstract T afterDelete(@NonNull T var1);

    @Nonnull
    protected T baseDelete(@NonNull T entityBase) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        entityBase.setRowVersion(entityBase.getRowVersion() + 1);
        entityBase.setEntityState(EntityState.DELETED);
        return (T)this.persistenceHelper.deleted(entityBase);
    }

    @Nonnull
    protected T baseUpdate(@NonNull T entityBase) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        return (T)this.baseUpdate(entityBase, true);
    }

    @Nonnull
    protected T baseUpdate(@NonNull T entityBase, boolean refreshUpdated) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        entityBase.setRowVersion(entityBase.getRowVersion() + 1);
        entityBase.setEntityState(EntityState.VALID);
        return (T)this.persistenceHelper.updated(entityBase, refreshUpdated);
    }

    @Nonnull
    public T byIdFailing(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Optional entityById = this.byIdNotFailing(id);
        if (entityById.isPresent()) {
            return (T)((EntityBase)entityById.get());
        }
        throw ResourceNotFoundException.of((String)this.clazz().getName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)Long.toString(id));
    }

    @Nonnull
    public Page<T> page(int page, int size) {
        return this.page((Pageable)PageRequest.of((int)page, (int)size));
    }

    @Nonnull
    public Page<T> page(@Nonnull Pageable pageable) {
        return this.repository.findAll(pageable);
    }

    @Nonnull
    public Optional<T> byIdNotFailing(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.repository.findById((Object)id);
    }

    @Nonnull
    public T update(@NonNull T item, boolean refreshUpdated) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        EntityBase entity = this.baseUpdate(this.beforeUpdate(item), refreshUpdated);
        return (T)this.afterUpdate((EntityBase)this.repository.save((Object)entity));
    }

    @Nonnull
    public T update(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return (T)this.update(item, true);
    }

    @Nonnull
    public Iterable<T> update(@NonNull Iterable<T> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return this.update(items, true);
    }

    @Nonnull
    public Iterable<T> update(@NonNull Iterable<T> items, boolean refreshUpdated) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        Streams.stream(items).forEach(item -> this.baseUpdate(this.beforeUpdate(item), refreshUpdated));
        List savedEntities = this.repository.saveAll(items);
        Streams.stream((Iterable)savedEntities).forEach(item -> this.baseUpdate(this.afterUpdate(item), refreshUpdated));
        return savedEntities;
    }

    @Nonnull
    public T delete(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return (T)this.afterDelete((EntityBase)this.repository.save((Object)this.baseDelete(this.beforeDelete(item))));
    }

    @Nonnull
    public Iterable<T> allByIds(@NonNull Iterable<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (Iterables.isEmpty(ids)) {
            return ImmutableList.of();
        }
        return this.repository.findAllById(ids);
    }
}

