/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.consumer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.eventbus.MeasurementChangeMessage;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementStateReason;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.PssHandler;
import de.qfm.erp.service.service.service.MeasurementService;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class MeasurementChangeMessageConsumer
implements ApplicationListener<MeasurementChangeMessage> {
    private static final Set<EMeasurementType> PREVENT_FURTHER_PSS_MEASUREMENT_TYPES = ImmutableSet.of((Object)EMeasurementType.MAIN);
    private static final Set<EMeasurementState> PREVENT_FURTHER_PSS_MEASUREMENT_STATE = ImmutableSet.of((Object)EMeasurementState.APPROVED, (Object)EMeasurementState.ACCOUNTED, (Object)EMeasurementState.IN_ACCOUNTING);
    private static final Set<EMeasurementType> ALLOW_FURTHER_PSS_MEASUREMENT_TYPES = ImmutableSet.of((Object)EMeasurementType.MAIN);
    private static final Set<EMeasurementState> ALLOW_FURTHER_PSS_MEASUREMENT_STATE = ImmutableSet.of((Object)EMeasurementState.TEMPORARY, (Object)EMeasurementState.IN_REVIEW, (Object)EMeasurementState.DELETED, (Object)EMeasurementState.CLOSED);
    public final MeasurementService measurementService;
    public final MeasurementHandler measurementHandler;
    public final PssHandler pssHandler;

    public void onApplicationEvent(@NonNull MeasurementChangeMessage changeMessage) {
        PssReleaseOrder pssReleaseOrder;
        ReleaseOrder releaseOrder;
        boolean measurementTypeChanged;
        if (changeMessage == null) {
            throw new NullPointerException("changeMessage is marked non-null but is null");
        }
        Measurement measurement = (Measurement)changeMessage.getEntity();
        EMeasurementState measurementStateFrom = changeMessage.getMeasurementStateOld();
        EMeasurementState measurementStateTo = changeMessage.getMeasurementStateNew();
        EMeasurementType measurementTypeFrom = changeMessage.getMeasurementTypeOld();
        EMeasurementType measurementTypeTo = changeMessage.getMeasurementTypeNew();
        boolean measurementStateChanged = !Objects.equals(measurementStateFrom, measurementStateTo);
        boolean bl = measurementTypeChanged = !Objects.equals(measurementTypeFrom, measurementTypeTo);
        if (EMeasurementType.PARTIAL == measurementTypeTo && EMeasurementState.APPROVED == measurementStateFrom && EMeasurementState.TEMPORARY == measurementStateTo) {
            Iterable measurementsWithSamePSSRO = changeMessage.getMeasurementsWithSamePSSRO();
            Iterable mainMeasurementsWithSamePSSRO = (Iterable)Streams.stream((Iterable)measurementsWithSamePSSRO).filter(item -> EMeasurementType.MAIN == item.getMeasurementType()).filter(item -> EMeasurementState.APPROVED == item.getMeasurementState().getMeasurementState()).collect(ImmutableList.toImmutableList());
            for (Measurement mainMeasurement : mainMeasurementsWithSamePSSRO) {
                this.measurementService.switchMeasurementState(mainMeasurement, EMeasurementState.TEMPORARY, EMeasurementStateReason.PSS);
                this.measurementHandler.update((EntityBase)mainMeasurement);
            }
        }
        if (PREVENT_FURTHER_PSS_MEASUREMENT_TYPES.contains(measurementTypeTo) && PREVENT_FURTHER_PSS_MEASUREMENT_STATE.contains(measurementStateTo)) {
            releaseOrder = measurement.getReleaseOrder();
            if (null != releaseOrder && null != (pssReleaseOrder = releaseOrder.getPssReleaseOrder()) && Boolean.FALSE == pssReleaseOrder.getFlagDisabled()) {
                pssReleaseOrder.setFlagDisabled(Boolean.valueOf(true));
                var11_11 = (PssReleaseOrder)this.pssHandler.update((EntityBase)pssReleaseOrder);
            }
        } else if (ALLOW_FURTHER_PSS_MEASUREMENT_TYPES.contains(measurementTypeTo) && ALLOW_FURTHER_PSS_MEASUREMENT_STATE.contains(measurementStateTo) && null != (releaseOrder = measurement.getReleaseOrder()) && null != (pssReleaseOrder = releaseOrder.getPssReleaseOrder()) && Boolean.TRUE == pssReleaseOrder.getFlagDisabled()) {
            pssReleaseOrder.setFlagDisabled(Boolean.valueOf(false));
            var11_11 = (PssReleaseOrder)this.pssHandler.update((EntityBase)pssReleaseOrder);
        }
    }

    public MeasurementChangeMessageConsumer(MeasurementService measurementService, MeasurementHandler measurementHandler, PssHandler pssHandler) {
        this.measurementService = measurementService;
        this.measurementHandler = measurementHandler;
        this.pssHandler = pssHandler;
    }
}

