/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class IncentiveWage_WageTypeCalculator
extends WageTypeCalculator {
    public IncentiveWage_WageTypeCalculator() {
        super(EWageType.INCENTIVE_WAGE);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        List allPayrollItems = payrollMonth.getPayrollMonthItems();
        Iterable allIncentivePayrollItems = payrollMonthCalculationBucket.getIncentivePayrollMonthItems();
        List userPayrollItems = payrollMonth.getPayrollMonthItems();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        User employee = payrollMonth.getUser();
        List attendances = payrollMonth.getAttendances();
        String description = payrollItemType.getDescription();
        Iterable incentivePayrollMonthItems = IncentiveWage_WageTypeCalculator.incentivePayment((Iterable)allIncentivePayrollItems);
        Iterable auxiliaryMappedAsIncentivePayrollMonthItems = IncentiveWage_WageTypeCalculator.auxiliaryMappedAsIncentivePayment((Iterable)allPayrollItems);
        Iterable wageAccountPayrollMonthItems = IncentiveWage_WageTypeCalculator.wageAccountPayment((Iterable)allPayrollItems);
        BigDecimal incentiveWageSum = WageCalculatorHelper.incentiveWageSum((Iterable)incentivePayrollMonthItems, (Iterable)auxiliaryMappedAsIncentivePayrollMonthItems, (Iterable)wageAccountPayrollMonthItems);
        Iterable relevantAttendances = this.workingAttendances((Iterable)attendances);
        BigDecimal deductibleHours = IncentiveWage_WageTypeCalculator.deductibleHours((Iterable)userPayrollItems);
        Duration workDuration = WageCalculatorHelper.durationInHours((Iterable)relevantAttendances, Attendance::getWorkDuration);
        BigDecimal workingHours = WageCalculatorHelper.hours((Duration)workDuration);
        BigDecimal workingHoursDeducted = workingHours.subtract(deductibleHours);
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal wageTotal = IncentiveWage_WageTypeCalculator.effectiveWageTotal((BigDecimal)workingHoursDeducted, (BigDecimal)effectiveWagePerHour);
        BigDecimal incentivePaymentWithoutWage = incentiveWageSum.subtract(wageTotal);
        BigDecimal incentiveWageRatePerHour = !BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{workingHoursDeducted}) ? incentivePaymentWithoutWage.divide(workingHoursDeducted, 2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        return ImmutableList.of((Object)WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)description, (BigDecimal)incentiveWageSum, (BigDecimal)workingHours, (BigDecimal)incentiveWageRatePerHour, (BigDecimal)incentivePaymentWithoutWage, (String)""));
    }
}

