/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AuxiliaryWageValue_WageTypeCalculator
extends WageTypeCalculator {
    public AuxiliaryWageValue_WageTypeCalculator() {
        super(EWageType.AUXILIARY_WAGE_VALUE);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        Collection payrollMonthItems = payrollMonthCalculationBucket.getPayrollMonthItemsByPayrollItemType().get((Object)payrollItemType);
        BigDecimal valuePerItem = ((BigDecimal)MoreObjects.firstNonNull((Object)payrollItemType.getValue(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal amount = Streams.stream((Iterable)payrollMonthItems).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal product = amount.multiply(valuePerItem).setScale(2, RoundingMode.HALF_UP);
        String description = StringUtils.trimToEmpty((String)payrollItemType.getDescription());
        return ImmutableList.of((Object)WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)description, (BigDecimal)BigDecimal.ZERO, (BigDecimal)amount, (BigDecimal)valuePerItem, (BigDecimal)product, (String)""));
    }
}

