/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AbsentDaysSum_WageTypeCalculator
extends WageTypeCalculator {
    private static final Iterable<EAttendanceDayType> PRESENT_DAYS = ImmutableSet.of((Object)EAttendanceDayType.STANDARD, (Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK, (Object)EAttendanceDayType.ABSENT);
    private static final Iterable<EDayType> DAY_TYPES = ImmutableSet.of((Object)EDayType.STANDARD);

    public AbsentDaysSum_WageTypeCalculator() {
        super(EWageType.ABSENT_DAYS__SUM);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        User employee = payrollMonth.getUser();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List attendances = payrollMonth.getAttendances();
        Iterable daysForAttendanceDayTypes = this.attendancesOfAttendanceDayTypes((Iterable)attendances, PRESENT_DAYS);
        Iterable daysWithDayTypeAndAttendanceDayType = this.attendancesOfDayTypes(daysForAttendanceDayTypes, DAY_TYPES);
        ImmutableMap.Builder gapWorkTimeVsContractBuilder = ImmutableMap.builder();
        for (Attendance attendance : daysWithDayTypeAndAttendanceDayType) {
            Duration workDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getWorkDuration(), (Object)Duration.ZERO);
            Duration badWeatherDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getBadWeatherDuration(), (Object)Duration.ZERO);
            Duration contractualWorkTime = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
            Duration gapWorkTimeVsContractSum = contractualWorkTime.minus(workDuration.plus(badWeatherDuration));
            if (gapWorkTimeVsContractSum.isZero()) continue;
            gapWorkTimeVsContractBuilder.put((Object)attendance, (Object)gapWorkTimeVsContractSum);
        }
        ImmutableMap gapWorkTimeVsContract = gapWorkTimeVsContractBuilder.build();
        Duration gapWorkTimeVsContractSum = gapWorkTimeVsContract.values().stream().reduce(Duration.ZERO, Duration::plus);
        BigDecimal missingTimeSum = !gapWorkTimeVsContractSum.isNegative() ? WageCalculatorHelper.hours((Duration)gapWorkTimeVsContractSum) : BigDecimal.ZERO;
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal wageTotalWithoutDeductions = AbsentDaysSum_WageTypeCalculator.effectiveWageTotal((BigDecimal)missingTimeSum, (BigDecimal)effectiveWagePerHour);
        String currentContractName = EmployeeHelper.currentContractName((User)employee, (YearMonth)yearMonth).orElse("");
        return ImmutableList.of((Object)WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)currentContractName, (BigDecimal)BigDecimal.ZERO, (BigDecimal)missingTimeSum, (BigDecimal)effectiveWagePerHour, (BigDecimal)wageTotalWithoutDeductions, (String)""));
    }

    @Nonnull
    @VisibleForTesting
    Iterable<Attendance> attendancesOfAttendanceDayTypes(@NonNull Iterable<Attendance> attendances, @NonNull Iterable<EAttendanceDayType> attendanceDayTypes) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (attendanceDayTypes == null) {
            throw new NullPointerException("attendanceDayTypes is marked non-null but is null");
        }
        ImmutableList.Builder absentDaysBuilder = ImmutableList.builder();
        for (EAttendanceDayType absentDay : attendanceDayTypes) {
            absentDaysBuilder.addAll(AbsentDaysSum_WageTypeCalculator.attendances(attendances, (EAttendanceDayType)absentDay));
        }
        return absentDaysBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    Iterable<Attendance> attendancesOfDayTypes(@NonNull Iterable<Attendance> attendances, @NonNull Iterable<EDayType> dayTypes) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (dayTypes == null) {
            throw new NullPointerException("dayTypes is marked non-null but is null");
        }
        ImmutableList.Builder absentDaysBuilder = ImmutableList.builder();
        for (EDayType dayType : dayTypes) {
            absentDaysBuilder.addAll(this.attendances(attendances, dayType));
        }
        return absentDaysBuilder.build();
    }
}

