/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.collect.Maps;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;

public abstract class AttendanceDurationAggregator {
    private final EAggregatedAttendanceDayType aggregatedAttendanceDayType;

    @Nonnull
    public abstract Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance var1);

    @Nonnull
    public Map<EAggregatedAttendanceDayType, BigDecimal> count(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        Map durations = this.duration(attendance);
        return Maps.transformValues((Map)durations, item -> {
            if (!item.isZero()) {
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        });
    }

    protected AttendanceDurationAggregator(EAggregatedAttendanceDayType aggregatedAttendanceDayType) {
        this.aggregatedAttendanceDayType = aggregatedAttendanceDayType;
    }

    public EAggregatedAttendanceDayType getAggregatedAttendanceDayType() {
        return this.aggregatedAttendanceDayType;
    }

    public String toString() {
        return "AttendanceDurationAggregator(aggregatedAttendanceDayType=" + String.valueOf(this.getAggregatedAttendanceDayType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttendanceDurationAggregator)) {
            return false;
        }
        AttendanceDurationAggregator other = (AttendanceDurationAggregator)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EAggregatedAttendanceDayType this$aggregatedAttendanceDayType = this.getAggregatedAttendanceDayType();
        EAggregatedAttendanceDayType other$aggregatedAttendanceDayType = other.getAggregatedAttendanceDayType();
        return !(this$aggregatedAttendanceDayType == null ? other$aggregatedAttendanceDayType != null : !this$aggregatedAttendanceDayType.equals(other$aggregatedAttendanceDayType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttendanceDurationAggregator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EAggregatedAttendanceDayType $aggregatedAttendanceDayType = this.getAggregatedAttendanceDayType();
        result = result * 59 + ($aggregatedAttendanceDayType == null ? 43 : $aggregatedAttendanceDayType.hashCode());
        return result;
    }
}

