/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.user;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.ASCIIFoldingHelper;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.UserHandler;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserNameGenerator {
    private static final Logger log = LogManager.getLogger(UserNameGenerator.class);
    private static final Joiner USER_NAME_JOINER = Joiner.on((String)"_").skipNulls();
    private final UserHandler userHandler;
    private static final CharMatcher DISALLOWED_CHARS_MATCHER = CharMatcher.inRange((char)'a', (char)'z').negate();

    @Nonnull
    public String generate(@Nullable Long id, @NonNull String firstName, @NonNull String lastName) {
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        if (lastName == null) {
            throw new NullPointerException("lastName is marked non-null but is null");
        }
        ImmutableSet existingUserNames = (ImmutableSet)this.userHandler.page(Pageable.unpaged()).stream().filter(item -> null == id || !Objects.equals(item.getId(), id)).map(User::getUsername).map(StringUtils::lowerCase).map(StringUtils::trimToNull).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        String firstNameCleaned = UserNameGenerator.clean((String)firstName);
        String lastNameCleaned = UserNameGenerator.clean((String)lastName);
        int maxLength = StringUtils.length((CharSequence)firstNameCleaned);
        AtomicReference<String> current = new AtomicReference<String>();
        for (int i = 1; i <= maxLength; ++i) {
            String left = StringUtils.left((String)firstNameCleaned, (int)i);
            String userNameCandidate = USER_NAME_JOINER.join((Object)left, (Object)lastNameCleaned, new Object[0]);
            current.set(userNameCandidate);
            if (existingUserNames.contains((Object)userNameCandidate)) continue;
            return userNameCandidate;
        }
        return USER_NAME_JOINER.join(current.get(), (Object)System.currentTimeMillis(), new Object[0]);
    }

    @Nonnull
    private static String clean(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String folded = ASCIIFoldingHelper.foldString((String)input);
        String lowerCased = StringUtils.lowerCase((String)folded);
        return DISALLOWED_CHARS_MATCHER.replaceFrom((CharSequence)lowerCased, (CharSequence)"_");
    }

    public UserNameGenerator(UserHandler userHandler) {
        this.userHandler = userHandler;
    }
}

