/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.quotation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import de.qfm.erp.service.model.internal.quotation.StageCalculationBucket;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.quotation.StageUpdatePositionCalculator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class StageUpdatePositionTypeCalculator
extends StageUpdatePositionCalculator {
    static final int ORDERING = 1;
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);

    public StageUpdatePositionTypeCalculator() {
        super(PROPERTIES, 1);
    }

    void calculateAndApply(@NonNull StageCalculationBucket stageCalculationBucket, @NonNull QuotationPosition position) {
        String surrogatePositionNumber;
        if (stageCalculationBucket == null) {
            throw new NullPointerException("stageCalculationBucket is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        Quotation stage = stageCalculationBucket.getStage();
        EQStageType stageType = stage.getStageType();
        EPositionType positionType = position.getPositionType();
        if ((positionType == EPositionType.STANDARD || positionType == EPositionType.CHANGE_IN_QUANTITY) && Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType) && StringUtils.isNotBlank((CharSequence)(surrogatePositionNumber = position.getSurrogatePositionNumber()))) {
            Multimap entityPositionsById = stageCalculationBucket.getEntityPositionsById();
            QuotationPosition referencePosition = position.getReferencePosition();
            if (null != referencePosition) {
                Long referencePositionId = referencePosition.getId();
                boolean mainContainsRef = entityPositionsById.containsKey((Object)referencePositionId);
                if (mainContainsRef) {
                    position.setPositionType(EPositionType.CHANGE_IN_QUANTITY);
                } else {
                    position.setPositionType(EPositionType.STANDARD);
                }
            }
        }
    }
}

