/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.quotation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.quotation.StagePositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StagePositionAmountCalculator
extends StagePositionCalculator {
    static final int ORDERING = -1;
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);

    public StagePositionAmountCalculator() {
        super(PROPERTIES, -1);
    }

    void calculateAndApply(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        BigDecimal orderedAmount = StagePositionAmountCalculator.normalize((BigDecimal)position.getOrderedAmount());
        BigDecimal pricePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getPricePerUnit());
        BigDecimal squadWagePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getSquadWagePerUnit());
        BigDecimal materialPurchasePricePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getMaterialWholesalePriceIncludingDiscountPerItem());
        BigDecimal externalServicePurchasePricePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getExternalServicePurchasePricePerUnit());
        BigDecimal materialSellingPricePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getMaterialSellingPricePerUnit());
        BigDecimal companyWagePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getCompanyWagePerItem());
        BigDecimal externalServiceSellingPricePerUnit = StagePositionAmountCalculator.normalize((BigDecimal)position.getExternalServiceSellingPricePerUnit());
        BigDecimal materialPurchasePriceAggregated = null != orderedAmount && null != materialPurchasePricePerUnit ? orderedAmount.multiply(materialPurchasePricePerUnit).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal materialSellingPriceAggregated = null != orderedAmount && null != materialSellingPricePerUnit ? orderedAmount.multiply(materialSellingPricePerUnit).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal squadWageAggregated = null != orderedAmount && null != squadWagePerUnit ? squadWagePerUnit.multiply(orderedAmount).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal companyWageAggregated = null != orderedAmount && null != companyWagePerUnit ? orderedAmount.multiply(companyWagePerUnit).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal externalServicePurchasePriceAggregated = null != orderedAmount && null != externalServicePurchasePricePerUnit ? orderedAmount.multiply(externalServicePurchasePricePerUnit).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal externalServiceSellingPriceAggregated = null != orderedAmount && null != externalServiceSellingPricePerUnit ? orderedAmount.multiply(externalServiceSellingPricePerUnit).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        position.setMaterialWholesalePriceIncludingDiscountAggregated(materialPurchasePriceAggregated);
        position.setMaterialSellingPriceAggregated(materialSellingPriceAggregated);
        position.setSquadWageAggregated(squadWageAggregated);
        position.setCompanyWageAggregated(companyWageAggregated);
        position.setExternalServicePurchasePriceAggregated(externalServicePurchasePriceAggregated);
        position.setExternalServiceSellingPriceAggregated(externalServiceSellingPriceAggregated);
        BigDecimal priceAggregated = null != orderedAmount && null != pricePerUnit ? pricePerUnit.multiply(orderedAmount).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        position.setPriceAggregated(priceAggregated);
        BigDecimal purchasePriceAggregated = ((BigDecimal)MoreObjects.firstNonNull((Object)materialPurchasePriceAggregated, (Object)BigDecimal.ZERO)).add((BigDecimal)MoreObjects.firstNonNull((Object)squadWageAggregated, (Object)BigDecimal.ZERO)).add((BigDecimal)MoreObjects.firstNonNull((Object)externalServicePurchasePriceAggregated, (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        if (purchasePriceAggregated.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal aggregatedPercentage = priceAggregated.divide(purchasePriceAggregated, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
            position.setAggregatedPercentage(aggregatedPercentage);
        } else {
            position.setAggregatedPercentage(BigDecimal.ZERO);
        }
    }

    @Nullable
    private static BigDecimal normalize(@Nullable BigDecimal value) {
        if (null != value) {
            return value.setScale(2, RoundingMode.HALF_UP);
        }
        return null;
    }
}

