/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.quotation;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.quotation.StageCalculator;
import de.qfm.erp.service.service.service.StageHelperService;
import java.math.BigDecimal;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StageBudgetCalculator
extends StageCalculator {
    private final StageHelperService stageHelperService;
    static final int ORDERING = Integer.MAX_VALUE;
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.POST_UPDATE);

    @Autowired
    public StageBudgetCalculator(StageHelperService stageHelperService) {
        super(PROPERTIES, Integer.MAX_VALUE);
        this.stageHelperService = stageHelperService;
    }

    void calculateAndApply(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        BigDecimal budget = this.stageHelperService.budget(stage);
        stage.setBudget(budget);
    }
}

