/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementPositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class MeasurementPositionMaterialPriceSyncCalculator
extends MeasurementPositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 4;

    public MeasurementPositionMaterialPriceSyncCalculator() {
        super(PROPERTIES, 4);
    }

    public void calculateAndApply(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal product = measurementPosition.getProduct();
        BigDecimal materialSellingPricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialSellingPricePerUnit());
        BigDecimal materialPurchasePricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialPurchasePriceIncludingDiscountPerUnit());
        BigDecimal materialSellingPriceAggregated = materialSellingPricePerUnit.multiply(product).setScale(2, RoundingMode.HALF_UP);
        measurementPosition.setMaterialSellingPriceAggregated(materialSellingPriceAggregated);
        BigDecimal materialPurchasePriceAggregated = materialPurchasePricePerUnit.multiply(product).setScale(2, RoundingMode.HALF_UP);
        measurementPosition.setMaterialPurchasePriceIncludingDiscountAggregated(materialPurchasePriceAggregated);
    }
}

