/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementCalculator;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class MeasurementAddendumNumbersCalculator
extends MeasurementCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 4;
    static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    public MeasurementAddendumNumbersCalculator() {
        super(PROPERTIES, 4);
    }

    public void calculateAndApply(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Iterable measurementPositions = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableSet.of());
        ImmutableSet addendumNumbers = (ImmutableSet)Streams.stream((Iterable)measurementPositions).map(item -> MeasurementHelper.addendumNumber((MeasurementPosition)item, (boolean)false)).collect(ImmutableSet.toImmutableSet());
        String addendumNumbersAsString = COMMA_JOINER.join((Iterable)addendumNumbers);
        measurement.setAddendumNumbers(addendumNumbersAsString);
    }
}

