/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.invoice;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.invoice.EInvoicePositionType;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAddendumDiscount;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.invoice.InvoiceSupplement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.invoice.InvoiceCalculator;
import de.qfm.erp.service.service.calculator.invoice.InvoiceWageAndValueSumCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class InvoiceWageAndValueSumCalculator
extends InvoiceCalculator {
    private static final Logger log = LogManager.getLogger(InvoiceWageAndValueSumCalculator.class);
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 0;

    public InvoiceWageAndValueSumCalculator() {
        super(PROPERTIES, 0);
    }

    public void calculateAndApply(@NonNull Invoice invoice, @NonNull Iterable<Invoice> cumulativeInvoices, boolean optionIgnoreAddendum) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (cumulativeInvoices == null) {
            throw new NullPointerException("cumulativeInvoices is marked non-null but is null");
        }
        BigDecimal subTotalWithoutDiscountValueNet = BigDecimal.ZERO;
        BigDecimal subTotalWithDiscountValueNet = BigDecimal.ZERO;
        BigDecimal totalValueNet = BigDecimal.ZERO;
        ArrayListMultimap discountableValuesNet = ArrayListMultimap.create();
        BigDecimal materialWholeSalePriceOverall = BigDecimal.ZERO;
        BigDecimal materialSellingPriceOverall = BigDecimal.ZERO;
        BigDecimal internalWageOverall = BigDecimal.ZERO;
        BigDecimal squadWageOverall = BigDecimal.ZERO;
        BigDecimal companyWageOverall = BigDecimal.ZERO;
        BigDecimal externalServicePPOverall = BigDecimal.ZERO;
        BigDecimal externalServiceSPOverall = BigDecimal.ZERO;
        Iterable invoicePositions = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoicePositions(), (Object)ImmutableSet.of());
        for (InvoicePosition invoicePosition : invoicePositions) {
            EInvoicePositionType invoicePositionType = invoicePosition.getInvoicePositionType();
            switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$invoice$EInvoicePositionType[invoicePositionType.ordinal()]) {
                case 1: {
                    BigDecimal priceAggregatedCP = invoicePosition.getPriceAggregated();
                    subTotalWithoutDiscountValueNet = subTotalWithoutDiscountValueNet.add(priceAggregatedCP);
                    BigDecimal materialPurchasePriceAggCP = (BigDecimal)MoreObjects.firstNonNull((Object)invoicePosition.getMaterialPurchasePriceAgg(), (Object)BigDecimal.ZERO);
                    materialWholeSalePriceOverall = materialWholeSalePriceOverall.add(materialPurchasePriceAggCP);
                    BigDecimal materialSellingPriceAggCP = (BigDecimal)MoreObjects.firstNonNull((Object)invoicePosition.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                    materialSellingPriceOverall = materialSellingPriceOverall.add(materialSellingPriceAggCP);
                    break;
                }
                case 2: {
                    MeasurementPosition measurementPosition = invoicePosition.getMeasurementPosition();
                    if (null == measurementPosition) break;
                    BigDecimal priceAggregatedMP = measurementPosition.getPriceAggregated();
                    subTotalWithoutDiscountValueNet = subTotalWithoutDiscountValueNet.add(priceAggregatedMP);
                    BigDecimal materialPurchasePriceAggMP = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getMaterialPurchasePriceIncludingDiscountAggregated(), (Object)BigDecimal.ZERO);
                    materialWholeSalePriceOverall = materialWholeSalePriceOverall.add(materialPurchasePriceAggMP);
                    BigDecimal materialSellingPriceAggMP = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                    materialSellingPriceOverall = materialSellingPriceOverall.add(materialSellingPriceAggMP);
                    Long addendumNumberMP = optionIgnoreAddendum ? Long.valueOf(0L) : (Long)MoreObjects.firstNonNull((Object)measurementPosition.getAddendumNumber(), (Object)0L);
                    Boolean flagFeePosition = (Boolean)MoreObjects.firstNonNull((Object)measurementPosition.getFlagFeePosition(), (Object)false);
                    if (!flagFeePosition.booleanValue()) {
                        discountableValuesNet.put((Object)addendumNumberMP, (Object)priceAggregatedMP);
                    }
                    BigDecimal internalWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getInternalWageAggregated(), (Object)BigDecimal.ZERO);
                    internalWageOverall = internalWageOverall.add(internalWageAggregated);
                    BigDecimal squadWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getInternalSquadWageAggregated(), (Object)BigDecimal.ZERO);
                    squadWageOverall = squadWageOverall.add(squadWageAggregated);
                    BigDecimal companyWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
                    companyWageOverall = companyWageOverall.add(companyWageAggregated);
                    BigDecimal externalServicePurchasePriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getExternalServicePurchasePriceAggregated(), (Object)BigDecimal.ZERO);
                    externalServicePPOverall = externalServicePPOverall.add(externalServicePurchasePriceAggregated);
                    BigDecimal externalServiceSellingPriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getExternalServiceSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                    externalServiceSPOverall = externalServiceSPOverall.add(externalServiceSellingPriceAggregated);
                    break;
                }
            }
        }
        Set invoiceAddendumDiscounts = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceAddendumDiscounts(), (Object)Sets.newHashSet());
        ImmutableMap invoiceAddendumDiscountMap = Maps.uniqueIndex((Iterable)invoiceAddendumDiscounts, InvoiceAddendumDiscount::getAddendumNumber);
        discountableValuesNet.asMap().forEach((arg_0, arg_1) -> InvoiceWageAndValueSumCalculator.lambda$calculateAndApply$0((Map)invoiceAddendumDiscountMap, invoiceAddendumDiscounts, arg_0, arg_1));
        subTotalWithDiscountValueNet = subTotalWithoutDiscountValueNet;
        for (Object invoiceAddendumDiscount : invoiceAddendumDiscounts) {
            subTotalWithDiscountValueNet = subTotalWithDiscountValueNet.add(invoiceAddendumDiscount.getValueNet());
        }
        Set invoiceSupplements = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceSupplements(), (Object)Sets.newHashSet());
        for (InvoiceSupplement invoiceSupplement : invoiceSupplements) {
            BigDecimal percent = (BigDecimal)MoreObjects.firstNonNull((Object)invoiceSupplement.getPercent(), (Object)BigDecimal.ZERO);
            BigDecimal supplementValue = percent.multiply(subTotalWithDiscountValueNet).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            invoiceSupplement.setValue(supplementValue);
        }
        totalValueNet = subTotalWithDiscountValueNet;
        for (InvoiceSupplement invoiceSupplement : invoiceSupplements) {
            totalValueNet = totalValueNet.add(invoiceSupplement.getValue());
        }
        BigDecimal vatPercent = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getVatPercent(), (Object)BigDecimal.ZERO);
        BigDecimal vatValue = totalValueNet.multiply(vatPercent).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal totalValueGross = totalValueNet.add(vatValue);
        boolean flagSecurityRetention = (Boolean)MoreObjects.firstNonNull((Object)invoice.getFlagSecurityRetention(), (Object)false);
        BigDecimal warrantySecurityRetentionPercent = invoice.getWarrantySecurityRetentionPercent();
        BigDecimal warrantySecurityRetentionValue = flagSecurityRetention ? totalValueNet.multiply(warrantySecurityRetentionPercent).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).negate() : BigDecimal.ZERO;
        BigDecimal fulfillmentSecurityRetentionPercent = invoice.getFulfillmentSecurityRetentionPercent();
        BigDecimal fulfillmentSecurityRetentionValue = flagSecurityRetention ? totalValueNet.multiply(fulfillmentSecurityRetentionPercent).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).negate() : BigDecimal.ZERO;
        EInvoiceType invoiceType = invoice.getInvoiceType();
        BigDecimal fulfillmentSecurityRetentionCumulativeValue = EInvoiceType.FINAL_INVOICE == invoiceType ? Streams.stream(cumulativeInvoices).map(item -> {
            BigDecimal otherWarrantySecurityRetentionValue = (BigDecimal)MoreObjects.firstNonNull((Object)item.getWarrantySecurityRetentionValue(), (Object)BigDecimal.ZERO);
            BigDecimal otherFulfillmentSecurityRetentionValue = (BigDecimal)MoreObjects.firstNonNull((Object)item.getFulfillmentSecurityRetentionValue(), (Object)BigDecimal.ZERO);
            return otherWarrantySecurityRetentionValue.add(otherFulfillmentSecurityRetentionValue);
        }).reduce(BigDecimal.ZERO, BigDecimal::add).negate() : BigDecimal.ZERO;
        BigDecimal invoiceDueValueGross = totalValueGross.add(warrantySecurityRetentionValue).add(fulfillmentSecurityRetentionValue).add(fulfillmentSecurityRetentionCumulativeValue);
        invoice.setSubtotalWithoutDiscountValueNet(subTotalWithoutDiscountValueNet);
        invoice.setSubtotalWithDiscountValueNet(subTotalWithDiscountValueNet);
        BigDecimal totalDiscountValueNet = subTotalWithoutDiscountValueNet.subtract(subTotalWithDiscountValueNet);
        invoice.setTotalDiscountValueNet(totalDiscountValueNet);
        invoice.setTotalValueNet(totalValueNet);
        invoice.setTotalValueGross(totalValueGross);
        invoice.setVatValue(vatValue);
        invoice.setWarrantySecurityRetentionValue(warrantySecurityRetentionValue);
        invoice.setFulfillmentSecurityRetentionValue(fulfillmentSecurityRetentionValue);
        invoice.setFulfillmentSecurityRetentionCumulativeValue(fulfillmentSecurityRetentionCumulativeValue);
        invoice.setInvoiceDueValueGross(invoiceDueValueGross);
        invoice.setInternalWageOverall(internalWageOverall.setScale(2, RoundingMode.HALF_UP));
        invoice.setSquadWageOverall(squadWageOverall.setScale(2, RoundingMode.HALF_UP));
        invoice.setCompanyWageOverall(companyWageOverall.setScale(2, RoundingMode.HALF_UP));
        invoice.setMaterialPurchasePriceOverall(materialWholeSalePriceOverall.setScale(2, RoundingMode.HALF_UP));
        invoice.setMaterialSellingPriceOverall(materialSellingPriceOverall.setScale(2, RoundingMode.HALF_UP));
        invoice.setExternalServicePurchasePriceOverall(externalServicePPOverall.setScale(2, RoundingMode.HALF_UP));
        invoice.setExternalServiceSellingPriceOverall(externalServiceSPOverall.setScale(2, RoundingMode.HALF_UP));
    }

    private static /* synthetic */ void lambda$calculateAndApply$0(Map invoiceAddendumDiscountMap, Set invoiceAddendumDiscounts, Long addendumNumber, Collection discountableValuesNetPA) {
        int positionAmount = discountableValuesNetPA.size();
        BigDecimal discountableValueNet = discountableValuesNetPA.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        InvoiceAddendumDiscount invoiceAddendumDiscount = (InvoiceAddendumDiscount)invoiceAddendumDiscountMap.get(addendumNumber);
        if (null != invoiceAddendumDiscount) {
            BigDecimal discount = invoiceAddendumDiscount.getPercent();
            BigDecimal discountValue = discount.multiply(discountableValueNet).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP).negate();
            invoiceAddendumDiscount.setDiscountableValueNet(discountableValueNet);
            invoiceAddendumDiscount.setValueNet(discountValue);
            invoiceAddendumDiscount.setPositionAmount(positionAmount);
        } else {
            log.warn("No AddendumDiscount on Invoice for Addendum: {}, existing: {}", (Object)addendumNumber, (Object)invoiceAddendumDiscounts);
        }
    }
}

