/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.attendance;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.attendance.AttendanceDurationCalculator;
import java.time.Duration;
import java.time.LocalTime;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Order(value=1)
public class AttendanceWorkDurationCalculator
extends AttendanceDurationCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 1;
    public static final Duration BREAK_30MIN = Duration.ofMinutes(30L);
    public static final Duration BREAK_45MIN = Duration.ofMinutes(45L);
    private static Range<Duration> BREAK_MANDATORY_0MIN = Range.closedOpen((Comparable)Duration.ofHours(0L), (Comparable)Duration.ofHours(6L));
    private static Range<Duration> BREAK_MANDATORY_30MIN = Range.closedOpen((Comparable)Duration.ofHours(6L), (Comparable)Duration.ofHours(8L));
    private static Range<Duration> BREAK_MANDATORY_45MIN = Range.atLeast((Comparable)Duration.ofHours(8L));

    public AttendanceWorkDurationCalculator() {
        super(PROPERTIES, 1);
    }

    void calculateAndApply(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        LocalTime start = attendance.getWorkStart();
        LocalTime end = attendance.getWorkEnd();
        Duration providedDuration = attendance.getBreakDuration();
        if (null != start && null != end) {
            Duration presenceTime = AttendanceWorkDurationCalculator.difference((LocalTime)start, (LocalTime)end);
            Duration breakDuration = AttendanceWorkDurationCalculator.breakDuration((Duration)providedDuration, (Duration)presenceTime);
            Duration effectiveWorkingTime = presenceTime.minus(breakDuration);
            attendance.setWorkDuration(effectiveWorkingTime);
        } else {
            attendance.setWorkDuration(Duration.ZERO);
        }
    }

    @VisibleForTesting
    static Duration breakDuration(@Nullable Duration providedDuration, @NonNull Duration presenceTime) {
        if (presenceTime == null) {
            throw new NullPointerException("presenceTime is marked non-null but is null");
        }
        Duration safeProvidedDuration = (Duration)MoreObjects.firstNonNull((Object)providedDuration, (Object)Duration.ZERO);
        if (BREAK_MANDATORY_0MIN.contains((Comparable)presenceTime)) {
            return safeProvidedDuration;
        }
        if (BREAK_MANDATORY_30MIN.contains((Comparable)presenceTime)) {
            return safeProvidedDuration.compareTo(BREAK_30MIN) > 0 ? safeProvidedDuration : BREAK_30MIN;
        }
        if (BREAK_MANDATORY_45MIN.contains((Comparable)presenceTime)) {
            return safeProvidedDuration.compareTo(BREAK_45MIN) > 0 ? safeProvidedDuration : BREAK_45MIN;
        }
        return Duration.ZERO;
    }
}

