/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.attendance;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.DurationHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.LocalTimeHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContractConfig;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.generic.BankingHoliday;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.BankingHolidayHandler;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AttendanceGenerator {
    private static final Logger log = LogManager.getLogger(AttendanceGenerator.class);
    private static final Iterable<DayOfWeek> NORMAL_WEEK_DAY = ImmutableSet.of((Object)DayOfWeek.MONDAY, (Object)DayOfWeek.TUESDAY, (Object)DayOfWeek.WEDNESDAY, (Object)DayOfWeek.THURSDAY);
    private static final Iterable<DayOfWeek> FRIDAY_WEEK_DAY = ImmutableSet.of((Object)DayOfWeek.FRIDAY);
    private final BankingHolidayHandler bankingHolidayHandler;

    @Nonnull
    public Iterable<Attendance> apply(@NonNull EAttendanceOrigin origin, @NonNull User user, @NonNull YearMonth yearMonth, @NonNull LaborUnionContract laborUnionContract, @NonNull Iterable<Attendance> attendances, @NonNull Iterable<LocalDate> notWorkingDays) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (notWorkingDays == null) {
            throw new NullPointerException("notWorkingDays is marked non-null but is null");
        }
        Iterable dates = (Iterable)Streams.stream(attendances).map(Attendance::getDate).collect(ImmutableSet.toImmutableSet());
        Optional min = Streams.stream((Iterable)dates).min(LocalDate::compareTo);
        Optional max = Streams.stream((Iterable)dates).max(LocalDate::compareTo);
        EFederalState federalState = (EFederalState)MoreObjects.firstNonNull((Object)laborUnionContract.getFederalState(), (Object)EFederalState.ALL);
        if (min.isPresent() && max.isPresent()) {
            LaborUnionContractConfig laborUnionContractConfig = EmployeeHelper.currentContractConfigFailing((YearMonth)yearMonth, (LaborUnionContract)laborUnionContract);
            User squadLeader = user.getSquadLeader();
            Iterable relatedBankingHolidays = this.bankingHolidayHandler.findByFederalStateAndYearMonthNotFailing(federalState, yearMonth);
            Multimap bankingHolidaysByDayOfMonth = MapsHelper.map((Iterable)relatedBankingHolidays, BankingHoliday::getDayOfMonth, item -> item);
            return (Iterable)Streams.stream(attendances).map(item -> this.apply(origin, bankingHolidaysByDayOfMonth, notWorkingDays, laborUnionContractConfig, squadLeader, item)).collect(ImmutableList.toImmutableList());
        }
        return attendances;
    }

    @Nonnull
    public Attendance apply(@NonNull EAttendanceOrigin origin, @NonNull Multimap<Integer, BankingHoliday> bankingHolidayByDayOfMonth, @NonNull Iterable<LocalDate> notWorkingDays, @NonNull LaborUnionContractConfig laborUnionContractConfig, @Nullable User squadLeader, @NonNull Attendance attendance) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (bankingHolidayByDayOfMonth == null) {
            throw new NullPointerException("bankingHolidayByDayOfMonth is marked non-null but is null");
        }
        if (notWorkingDays == null) {
            throw new NullPointerException("notWorkingDays is marked non-null but is null");
        }
        if (laborUnionContractConfig == null) {
            throw new NullPointerException("laborUnionContractConfig is marked non-null but is null");
        }
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        LocalDate date = attendance.getDate();
        int dayOfMonth = date.getDayOfMonth();
        boolean isNonWorkingDay = Iterables.contains(notWorkingDays, (Object)date);
        boolean isBankingHoliday = bankingHolidayByDayOfMonth.containsKey((Object)dayOfMonth);
        EDayType defaultDayType = isBankingHoliday ? EDayType.BANKING_HOLIDAY : EDayType.STANDARD;
        attendance.setDayType(defaultDayType);
        attendance.setOrigin(origin);
        attendance.setConstructionSite("");
        this.applyContractData(laborUnionContractConfig, squadLeader, attendance, isNonWorkingDay);
        return attendance;
    }

    @Nonnull
    public Attendance reset(@NonNull Attendance attendance, boolean nonWorkingDay) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        PayrollMonth payrollMonth = attendance.getPayrollMonth();
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        User squadLeader = user.getSquadLeader();
        LaborUnionContract laborUnionContract = EmployeeHelper.currentLaborUnionContractFailing((User)user, (YearMonth)accountingMonth);
        LaborUnionContractConfig laborUnionContractConfig = EmployeeHelper.currentContractConfigFailing((YearMonth)accountingMonth, (LaborUnionContract)laborUnionContract);
        attendance.setLastOrigin(EAttendanceOrigin.BAD_WEATHER);
        attendance.setConstructionSite("");
        return this.applyContractData(laborUnionContractConfig, squadLeader, attendance, nonWorkingDay);
    }

    @Nonnull
    public Attendance applyContractData(@NonNull LaborUnionContractConfig laborUnionContractConfig, @Nullable User squadLeader, @NonNull Attendance attendance, boolean isNonWorkingDay) {
        Duration contractualWorkingDuration;
        Duration workingDuration;
        Duration breakDuration;
        LocalTime workingEnd;
        LocalTime workingBegin;
        boolean isBankingHoliday;
        if (laborUnionContractConfig == null) {
            throw new NullPointerException("laborUnionContractConfig is marked non-null but is null");
        }
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        LocalDate date = attendance.getDate();
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        boolean isWeekend = dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY;
        EDayType dayType = attendance.getDayType();
        boolean bl = isBankingHoliday = dayType == EDayType.BANKING_HOLIDAY;
        if (!isNonWorkingDay && !isBankingHoliday) {
            if (Iterables.contains((Iterable)NORMAL_WEEK_DAY, (Object)dayOfWeek)) {
                workingBegin = LocalTimeHelper.zeroToNull((LocalTime)laborUnionContractConfig.getNormalWorkingBegin());
                workingEnd = LocalTimeHelper.zeroToNull((LocalTime)laborUnionContractConfig.getNormalWorkingEnd());
                breakDuration = DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getNormalBreakDuration());
                workingDuration = DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getNormalWorkingHoursDuration());
                contractualWorkingDuration = DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getNormalWorkingHoursDuration());
            } else if (Iterables.contains((Iterable)FRIDAY_WEEK_DAY, (Object)dayOfWeek)) {
                workingBegin = LocalTimeHelper.zeroToNull((LocalTime)laborUnionContractConfig.getFridayWorkingBegin());
                workingEnd = LocalTimeHelper.zeroToNull((LocalTime)laborUnionContractConfig.getFridayWorkingEnd());
                breakDuration = DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getFridayBreakDuration());
                workingDuration = DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getFridayWorkingHoursDuration());
                contractualWorkingDuration = DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getFridayWorkingHoursDuration());
            } else {
                workingBegin = null;
                workingEnd = null;
                workingDuration = null;
                breakDuration = null;
                contractualWorkingDuration = null;
            }
        } else {
            workingBegin = null;
            workingEnd = null;
            workingDuration = null;
            breakDuration = null;
            contractualWorkingDuration = !isNonWorkingDay && Iterables.contains((Iterable)NORMAL_WEEK_DAY, (Object)dayOfWeek) ? DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getNormalWorkingHoursDuration()) : (!isNonWorkingDay && Iterables.contains((Iterable)FRIDAY_WEEK_DAY, (Object)dayOfWeek) ? DurationHelper.zeroToNull((Duration)laborUnionContractConfig.getFridayWorkingHoursDuration()) : null);
        }
        attendance.setWorkStart(workingBegin);
        attendance.setWorkEnd(workingEnd);
        attendance.setWorkDuration(workingDuration);
        attendance.setBreakDuration(breakDuration);
        EAttendanceDayType defaultAttendanceDayType = isNonWorkingDay || isWeekend || isBankingHoliday || null == workingBegin ? EAttendanceDayType.NONE : EAttendanceDayType.STANDARD;
        attendance.setDefaultEmployeeDayType(defaultAttendanceDayType);
        attendance.setDefaultWorkStart(workingBegin);
        attendance.setDefaultWorkEnd(workingEnd);
        attendance.setDefaultWorkDuration(workingDuration);
        attendance.setDefaultBreakDuration(breakDuration);
        attendance.setDefaultSquadLeader(squadLeader);
        attendance.setBadWeatherDuration(null);
        attendance.setContractualWorkTimeDuration(contractualWorkingDuration);
        Duration safeWorkDuration = (Duration)MoreObjects.firstNonNull((Object)workingDuration, (Object)Duration.ZERO);
        if (!safeWorkDuration.isZero()) {
            attendance.setEmployeeDayType(defaultAttendanceDayType);
            attendance.setSquadLeader(squadLeader);
        } else {
            attendance.setEmployeeDayType(EAttendanceDayType.NONE);
            attendance.setSquadLeader(null);
        }
        return attendance;
    }

    public AttendanceGenerator(BankingHolidayHandler bankingHolidayHandler) {
        this.bankingHolidayHandler = bankingHolidayHandler;
    }
}

