/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource.administration;

import de.qfm.erp.service.service.route.AdministrationRoute;
import de.qfm.erp.service.service.service.socket.StageWebSocketHandler;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.annotations.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Payroll Month Administration Resource", tags={"PayrollMonthAdministrationResource"})
@SwaggerDefinition(tags={@Tag(name="PayrollMonthAdministrationResource", description="All Operations around Administration")})
@ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved Entity / List"), @ApiResponse(code=401, message="You are not authorized to view the resource"), @ApiResponse(code=403, message="Accessing the resource you were trying to reach is forbidden"), @ApiResponse(code=404, message="The resource you were trying to reach is not found")})
@RestController
@RequestMapping(value={"/api/v1/erp/administration"})
public class StageAdministrationResource {
    private static final Logger log = LogManager.getLogger(StageAdministrationResource.class);
    private final AdministrationRoute administrationRoute;
    private final StageWebSocketHandler stageWebSocketHandler;

    @ApiOperation(value="Ensure Budgets for Stages", produces="application/json")
    @GetMapping(value={"/stages/_refresh_budgets/"}, produces={"application/json"})
    public int refreshBudgets() {
        return this.administrationRoute.refreshBudgets();
    }

    @ApiOperation(value="Remove Stage WS Sessions for StageId", produces="application/json")
    @GetMapping(value={"/websocket/stages/{stageId}/_clear/"}, produces={"application/json"})
    public boolean refreshBudgets(@PathVariable(value="stageId") long stageId) {
        return this.stageWebSocketHandler.remove(stageId);
    }

    @Autowired
    public StageAdministrationResource(AdministrationRoute administrationRoute, StageWebSocketHandler stageWebSocketHandler) {
        this.administrationRoute = administrationRoute;
        this.stageWebSocketHandler = stageWebSocketHandler;
    }
}

