/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import de.qfm.erp.common.response.user.UserAutoCompleteResponse;
import de.qfm.erp.service.service.route.AutoCompleteRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="User/Employee AutoComplete Resource", name="UserAutoCompleteResource")
@OpenAPIDefinition(tags={@Tag(name="UserAutoCompleteResource", description="All Operations around Users/Employees AutoComplete")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
@RestController
@RequestMapping(value={"/api"})
public class UserAutoCompleteResource {
    private static final Logger log = LogManager.getLogger(UserAutoCompleteResource.class);
    private final AutoCompleteRoute autoCompleteRoute;

    @Operation(summary="User AutoComplete V1")
    @GetMapping(value={"/v1/erp/users/{id}/_autocomplete/"})
    public UserAutoCompleteResponse autocompleteV1(@PathVariable(value="id") long userId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Mode: ALL = all (active) users (at reference_date), PAYROLL_MONTH = only Users which an create a payroll at reference_date", example="PAYROLL_MONTH, ALL") @RequestParam(value="autocomplete_mode", defaultValue="all") String autoCompleteMode, @Parameter(description="Reference Date to be used for validation(s)", example="YYYY-MM-YY / ISO DATE String / today") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="reference_date", defaultValue="") LocalDate referenceDate) {
        return this.autoCompleteRoute.standardAutoCompleteV1(userId, autoCompleteMode, filterText, referenceDate);
    }

    @Operation(summary="User AutoComplete V2")
    @GetMapping(value={"/v2/erp/users/{id}/_autocomplete/"})
    public UserAutoCompleteResponse autocompleteV2(@PathVariable(value="id") long userId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Mode: ALL_ACTIVE_AT_DATE = all Users active at a Date (reference_date), ALL_ACTIVE_IN_DATE_RANGE = all users active in a given Period (reference_date_range_*)", example="ALL_ACTIVE_AT_DATE, ALL_ACTIVE_IN_DATE_RANGE") @RequestParam(value="autocomplete_mode", defaultValue="ALL_ACTIVE_AT_DATE") String autoCompleteMode, @Parameter(description="Reference Date (from/to similar) to be used for validation(s)", example="YYYY-MM-YY / ISO DATE String / today") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="reference_date", defaultValue="") LocalDate referenceDate, @Parameter(description="Reference Date Range to Date to be used for validation(s)", example="YYYY-MM-YY / ISO DATE String / min") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="reference_date_range_from", defaultValue="") LocalDate referenceDateRangeFrom, @Parameter(description="Reference Date Range to Date to be used for validation(s)", example="YYYY-MM-YY / ISO DATE String / max") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="reference_date_range_to", defaultValue="") LocalDate referenceDateRangeTo, @Parameter(description="Truncate Date Check to Month", example="false") @RequestParam(value="option_truncate_date_to_month", defaultValue="false") Boolean unsafeOptionTruncateDateToMonth) {
        boolean safeOptionTruncateDateToMonth = (Boolean)MoreObjects.firstNonNull((Object)unsafeOptionTruncateDateToMonth, (Object)false);
        return this.autoCompleteRoute.standardAutoCompleteV2(userId, autoCompleteMode, filterText, referenceDate, referenceDateRangeFrom, referenceDateRangeTo, safeOptionTruncateDateToMonth);
    }

    public UserAutoCompleteResource(AutoCompleteRoute autoCompleteRoute) {
        this.autoCompleteRoute = autoCompleteRoute;
    }
}

